(function ($) {
	
	/*
	<nav class="aui-navgroup aui-navgroup-horizontal">
	    <div class="aui-navgroup-inner">
	        <div class="aui-navgroup-primary">
	            <ul class="aui-nav">
	                <li><a href="#">Nav item</a></li>
	                <li><a href="#">Nav item</a></li>
	                <li><a href="#">Nav item</a></li>
	                <li><a href="#">Nav item <span class="aui-badge">12</span></a></li>
	                <li><a href="#">Nav item</a></li>
	            </ul>
	        </div><!-- .aui-navgroup-primary -->
	    </div><!-- .aui-navgroup-inner -->
	</nav>

	<div class="aui-dropdown2 aui-style-default" id="hnavsettings-dropdown" data-dropdown2-alignment="right">
	    <ul>
	        <li><a href="#" class="">Nav dropdown item</a></li>
	        <li><a href="#" class="active">Nav dropdown item</a></li>
	        <li><a href="#">Nav dropdown item</a></li>
	    </ul>
	</div>

	*/

	ThemePress.Menu = {
		
		uniqueId: 0,
		$primary: false,
		
		activateExpandMacros: function () {
			$(".brikit-menu-panel .expand-content").each(function () {
				var $expandContent = $(this);
				var $expandContainer = $expandContent.closest(".expand-container");
				var $expandControl = $expandContent.prev(".expand-control");
				var $expandIcon    = $(".expand-control-icon", $expandControl);
				$expandContent.hide().removeClass("expand-hidden");
				$expandControl.click(function () {
					$expandContent.slideToggle("fast");
					$expandIcon.toggleClass("expanded");
				})
			})
		},
		
		doNotConvertForMobile: function () {
			return $(".brikit-menu").hasClass("do-not-convert-for-mobile");
		},

		fluidMenuClicked: function ($node) {

			var $content = $node.find("ul:first");

			// Skip leaf nodes or links
			if (!$content.length) return;
			
			var closing = $node.hasClass("expanded");
			$node.siblings("li").slideToggle(closing ? 0 : "fast");
			$content.slideToggle(closing ? 0 : "fast");
			$node.toggleClass("expanded");
			
			// Reset sub-menus when closing
			if (closing) {
				$("ul", $node).hide();
				$node.find("li").show();
				$(".expanded", $node).removeClass("expanded");
			}
			return false;
		},
		
		// Initialize the menu after page load
		initialize: function () {
			
			if (ThemePress.Menu.isMultiLevel()) return ThemePress.Menu.initializeMultiLevelMenu();
		
			// Grab the menu panels before we start pulling apart the menu
			var $firstLayer = ThemePress.Menu.menu(".brikit-architect-page-container").first();
			var $panels = ThemePress.Menu.menu(".brikit-architect-page-container").not($firstLayer).remove();

			// Prune illegal levels of menus
			ThemePress.Menu.menu("li ul ul").remove();
						
			// Grab the first ul element to use as the menu
			var $menus = ThemePress.Menu.menu("ul").filter(function () { return (!$(this).parents(".brikit-menu ul").length); });
			
			// If no menus, stop
			if (!$menus.length) return;
			
			ThemePress.Menu.$primary = $menus.first().addClass("aui-nav");
			
			// Flag the first top menu item
			var $menuItems = ThemePress.Menu.$primary.find("li");
			$menuItems.first().addClass("first");
			$menuItems.last().addClass("last");
			
			// Place the ul into the menu template
			var $menu = $("#brikit-menu-template").clone().show().removeAttr("id").addClass("brikit-menu");
			if (ThemePress.Menu.$primary) $menu.find(".aui-navgroup-primary").append(ThemePress.Menu.$primary);
			
			// Replace the brikit-menu in the DOM with the new menu
			ThemePress.Menu.menu().replaceWith($menu);
			
			// Set up plain top-level menu items -- non-dropdown
			$("li", ThemePress.Menu.$primary).filter(function () { return !$("ul", this).length && !$(this).parents(".brikit-menu ul li").length; }).each( function () {
				// Make sure that plain top-level menu items get an extra class
				$(this).addClass("top-level no-dropdown");

				// Make sure that plain text top-level menu items appear as AUI links, and 
				// flag them as invalid to help user know it's the configuration, not the tool
				if (!$("a, #move-simple-toolbar", this).length && !$("a, .do-not-remove", this).length) {
					var $el = ThemePress.Menu.skipParagraph($(this));
					// If an item contains an inline comment, use it's contents for the text
					if ($el.find(".inline-comment-marker").length) $el = $el.find(".inline-comment-marker");
					$(this).html("<a href='#'>" + $el.textForElementOnly() + "</a>").addClass("invalid-top-level-menu-link");
				}
			});

			// Yank out the dropdowns and put them after the menus
			if (ThemePress.Menu.$primary) $(ThemePress.Menu.$primary).find("li ul").each(function () {
				ThemePress.Menu.uniqueId += 1; 
				var id = "brikit-dropdown-" + ThemePress.Menu.uniqueId;
				
				// Give the top-level menu an extra class, and make sure it turns off menu panels triggers that are active
				var $listElement = $(this).closest(".brikit-menu li")
					.addClass("top-level has-dropdown")
					.click(function () { $(".brikit-menu-panel-trigger.active").removeClass("active"); });

				// Make sure that plain text items in the dropdown menu appear as AUI links
				$("li", this).each( function () {
					if (!$("a, strong", this).length) {
						$(this).html("<a href='#'>" + $(this).text() + "</a>");
						ThemePress.Menu.markInvalidLink($(this).find("a"));
					}
				});

				var $container = $("#brikit-dropdown-template").clone().attr("id", id).append(this);

				// If the menu item doesn't contain a link element, wrap its text in one, add back the dropdown, 
				// and replace the original menu item with it
				if (!$("a", $listElement).length) $listElement.html("<a href='#'>" + $listElement.textForElementOnly() + "</a>");

				var $trigger = $listElement.find("a").first().attr("href", id);
				if (ThemePress.Browser.mobile) {
					$trigger.addClass("brikit-menu-dropdown-trigger");
					ThemePress.Menu.initializeMobileMenu($trigger, $container);
				}
				else {
					$trigger.addClass("aui-dropdown2-trigger").attr("aria-owns", id).attr("aria-has-popup", "true");
				}

				ThemePress.Menu.menu().append($container);
			});
			
			// Make the menu visible before wiring the menu panels so the size calculations have a chance to work
			ThemePress.Menu.menu().showIf(!themePressMobile || ThemePress.Menu.doNotConvertForMobile());
			
			// Wire up each dropdown menu panel to the menu tab with matching name
			$panels.each(ThemePress.Menu.initializeMenuPanel);
			$(".brikit-canvas").click(function () {
				$(".brikit-menu-panel-trigger.active").removeClass("active");
				$(".brikit-menu-panel").hide();
				$("body").removeClass("menu-panel-open");
			});
			
			// Remove empty paragraph tags from menu panels (caused by some inline macros)
			$(".brikit-menu-panel p").each(function () {
				if (!jQuery.trim($(this).html()).length) $(this).remove();
			});
			
			// Many any remaining non-link top-level menu items show an error panel when clicked
			$(".brikit-menu .invalid-top-level-menu-link").each(function () {
				ThemePress.Menu.markInvalidLink($("a", this));
			});
		},
		
		initializeFluidMenus: function () {
			// Hide all sub-menus
			$(".fluid-menu li ul").hide();
			
			// Mark leaf nodes
			$(".fluid-menu li").each(function () {
				if ($(this).find("ul").length) return;
				$(this).addClass("leaf-node");
			});

			// Flag <a> elements that aren't links
			$(".fluid-menu li a").each(function () {
				if (!$(this).hasAttr("href")) $(this).addClass("not-link");
			});
			
			// Clicking on the list elements should toggle the submenus
			$(".fluid-menu").on("click", "li", function (event) {
				event.preventDefault();
				event.stopPropagation();
				return ThemePress.Menu.fluidMenuClicked($(this));
			});
			
			// But allow links to click through (and not toggle submenus)
			$(".fluid-menu").on("click", "li a", function (event) {
				event.stopPropagation();
			});
			
		},
		
		initializeMenuPanel: function () {

			// Find a matching menu for the menu panel, bailing if no match found
			var $panel = $(this);
			var panelName = $('<div/>').html($panel.data("name")).text();	// PRESS-665
			var $trigger = ThemePress.Menu.menu(".top-level.no-dropdown").filter(function () {
				var name = panelName;
				var textTitle = $.trim($("a", this).textForElementOnly());
				if (!textTitle) textTitle = $("a", this).attr("title");
				return name && textTitle && textTitle.toLowerCase() == name.toLowerCase();
			});
			if (!$trigger.length) return;
			
			$trigger.removeClass("invalid-top-level-menu-link no-dropdown").addClass("has-menu-panel").attr("data-panel-name", panelName);
			
			// Get the next unique id
			ThemePress.Menu.uniqueId += 1; 
			var id = "brikit-dropdown-" + ThemePress.Menu.uniqueId;

			// Wrap the dropdown in a div connected to the trigger
			var $menuPanel = $(".brikit-architect-container-content", $panel);
			// Transfer any macro-generated styles from the panel to the container
			var styles = $menuPanel.attr("style");
			$menuPanel.attr("style", "");
			var $container = $("#brikit-menu-panel-template").clone()
				.attr("id", id)
				.attr("style", styles)
				.attr("data-position", $panel.data("position"))
				.append($menuPanel);

			// Transfer the width from the layer-container
			var $sourceContainer = $(".brikit-architect-table", $panel);
			var containerWidth = $sourceContainer.data("width");
			if (containerWidth) {
				// Convert percentages to pixels based on width of the header
				if (containerWidth.indexOf("%") != -1) containerWidth = parseInt(containerWidth) * ThemePress.Structure.headerWidth() / 100;
				$container.width(containerWidth);
			}
			
			$("body").append($container);
			
			// Trigger the menu panel with the top-level menu item
			var $triggerLink = $trigger.find("a").first()
				.addClass("brikit-menu-panel-trigger aui-style-default")
				.attr("href", id)
				.attr("aria-owns", id)
				.attr("aria-has-popup", "true");
			
			$trigger.click(function (event) {
				event.preventDefault();
                event.stopPropagation();
                if (!$triggerLink.hasClass("active")) $(".brikit-canvas").click(); // Deactivates any previously active menu item
				$triggerLink.toggleClass("active");
				var panelOpen = $triggerLink.hasClass("active");
				$("body").adjustClass("menu-panel-open", panelOpen);
				if (ThemePress.Browser.mobile) ThemePress.Mobile.updateScrollPrevention();
				// TODO: if (panelOpen) $triggerLink.scrollToBeVisible();
				$(".brikit-menu-panel").not($container).hide();
				ThemePress.Menu.positionMenuPanel($trigger);
                $container.toggle();
			})
		},
		
		initializeMobileMenu: function ($trigger, $container) {

			// Make the container fill the whole screen, but letting the menu show through
			$container.removeClass("aui-dropdown2");
			
			$trigger.click(function (event) {
				event.preventDefault();
                event.stopPropagation();
                if (!$trigger.hasClass("active")) $(".brikit-canvas").click(); // Deactivates any previously active menu item
				$trigger.toggleClass("active");
				var panelOpen = $trigger.hasClass("active");
				$("body").adjustClass("menu-panel-open", panelOpen);
				$(".brikit-menu-panel").not($container).hide();
				ThemePress.Menu.positionMobileMenu($trigger, $container);
                $container.toggle();
			});
		},

		initializeMultiLevelMenu: function () {
			
			// Only consider the first layer
			var $firstLayer = ThemePress.Menu.menu(".brikit-architect-page-container").first();

			// Grab the first ul element to use as the menu
			var $menus = ThemePress.Menu.menu("ul").first();
			
			// If no menus, stop
			if (!$menus.length) return;
			
			ThemePress.Menu.$primary = $menus.first().addClass("aui-nav");
			
			// Flag the first top menu item
			var $menuItems = ThemePress.Menu.$primary.find(">li");
			$menuItems.first().addClass("first");
			$menuItems.last().addClass("last");
			
			// Place the ul into the menu template
			var $menu = $("#brikit-menu-template").clone().show().removeAttr("id").addClass("brikit-menu multi-level-menu");
			if (ThemePress.Menu.$primary) $menu.find(".aui-navgroup-primary").append(ThemePress.Menu.$primary);
			
			// Replace the brikit-menu in the DOM with the new menu
			ThemePress.Menu.menu().replaceWith($menu);
			
			// TODO: Multi-level menus not yet supported for desktop
			return;
			
			// Set up plain top-level menu items -- non-dropdown
			$("li", ThemePress.Menu.$primary).filter(function () { return !$("ul", this).length && !$(this).parents(".brikit-menu ul li").length; }).each( function () {
				// Make sure that plain top-level menu items get an extra class
				$(this).addClass("top-level no-dropdown");

				// Make sure that plain text top-level menu items appear as AUI links, and 
				// flag them as invalid to help user know it's the configuration, not the tool
				if (!$("a, #move-simple-toolbar", this).length && !$("a, .do-not-remove", this).length) {
					var $el = ThemePress.Menu.skipParagraph($(this));
					// If an item contains an inline comment, use it's contents for the text
					if ($el.find(".inline-comment-marker").length) $el = $el.find(".inline-comment-marker");
					$(this).html("<a href='#'>" + $el.textForElementOnly() + "</a>").addClass("invalid-top-level-menu-link");
				}
			});

			// Yank out the dropdowns and put them after the menus
			if (ThemePress.Menu.$primary) $(ThemePress.Menu.$primary).find("li ul").each(function () {
				ThemePress.Menu.uniqueId += 1; 
				var id = "brikit-dropdown-" + ThemePress.Menu.uniqueId;
				
				// Give the top-level menu an extra class, and make sure it turns off menu panels triggers that are active
				var $listElement = $(this).closest(".brikit-menu li")
					.addClass("top-level has-dropdown")
					.click(function () { $(".brikit-menu-panel-trigger.active").removeClass("active"); });

				// Make sure that plain text items in the dropdown menu appear as AUI links
				$("li", this).each( function () {
					if (!$("a, strong", this).length) {
						$(this).html("<a href='#'>" + $(this).text() + "</a>");
						ThemePress.Menu.markInvalidLink($(this).find("a"));
					}
				});

				var $container = $("#brikit-dropdown-template").clone().attr("id", id).append(this);

				// If the menu item doesn't contain a link element, wrap its text in one, add back the dropdown, 
				// and replace the original menu item with it
				if (!$("a", $listElement).length) $listElement.html("<a href='#'>" + $listElement.textForElementOnly() + "</a>");

				var $trigger = $listElement.find("a").first()
					.attr("href", id)
					.addClass("aui-dropdown2-trigger")
					.attr("aria-owns", id)
					.attr("aria-has-popup", "true");

				ThemePress.Menu.menu().append($container);
			});
			
			// Make the menu visible before wiring the menu panels so the size calculations have a chance to work
			ThemePress.Menu.menu().show();
			
			// Wire up each dropdown menu panel to the menu tab with matching name
			$panels.each(ThemePress.Menu.initializeMenuPanel);
			$(".brikit-canvas").click(function () {
				$(".brikit-menu-panel-trigger.active").removeClass("active");
				$(".brikit-menu-panel").hide();
			});
			
			// Remove empty paragraph tags from menu panels (caused by some inline macros)
			$(".brikit-menu-panel p").each(function () {
				if (!jQuery.trim($(this).html()).length) $(this).remove();
			});
			
			// Many any remaining non-link top-level menu items show an error panel when clicked
			$(".brikit-menu .invalid-top-level-menu-link").each(function () {
				ThemePress.Menu.markInvalidLink($("a", this));
			});
		},
		
		isMultiLevel: function () {
			return ThemePress.Menu.menu().hasClass("multi-level-menu");
		},

		markInvalidLink: function (element) {
			ThemePress.Dialog2.inline($(element), "Not a link", "This menu item is not a valid link.");
		},

		// Return the menu, or items matching selector inside the menu, if provided
		menu: function (selector) {
			var $menu = $(".brikit-menu");
			return selector ? $menu.find(selector) : $menu;
		},
		
		positionMenuPanel: function ($trigger) {

			var $header = ThemePress.Structure.header();
			var headerWidth = ThemePress.Structure.headerWidth();
            var xScroll = window.scrollX;
            var yScroll = window.scrollY;
			var headerLeft = $header.offset().left - xScroll;
			var headerRight = headerLeft + headerWidth;

			// Calculate the panel's location relative its trigger or the menu positioner
			var id = $trigger.find("a").attr("href");
			var $panel = $("#" + id);
			var position = $panel.data("position");
			
			var panelWidth = $panel.outerWidth();
			var triggerOffset = $trigger.offset();
            
			// If the panel fits within the content container in the header, left align it with the menu trigger
			var x = triggerOffset.left - xScroll;
			// If the panel is wider than the content container, center the panel on it
			if (panelWidth >= headerWidth) x = headerLeft - (panelWidth - headerWidth) / 2
			// Otherwise, right align to the content container
			else if ((x + panelWidth) > headerRight) x = headerRight - panelWidth;
			
			// If the panel is centered, place it in the middle of the page
			if (position == "centered") x = ($("#main").outerWidth(true) - panelWidth + $("#main").offset().left - xScroll) / 2;
			
            // Limit the menu position to be non-negative so the panel sticks to the top of the window when scrolling with headers that scroll with the page
            // Offsetting by the yScroll prevents the panel from moving away from the header when scrolling with headers that show on scroll
			var y = Math.max(0, triggerOffset.top - yScroll + $trigger.outerHeight());
			$panel.css({ top: 0, left: 0, right: "auto", bottom: "auto", transform: "translateX(" + x + "px) translateY(" + y + "px)" });
		},
		
		positionMenuPanels: function () {
            // Quality by .menu-panel-open to avoid updating when no menu panels are open
			$("body.menu-panel-open .brikit-menu-panel:visible").each(function () {
				var $trigger = $(".brikit-menu-panel-trigger[href=" + $(this).attr("id") + "]").closest("li");
				ThemePress.Menu.positionMenuPanel($trigger);
			});
		},

		positionMobileMenu: function ($trigger, $container) {
			var y = $(".brikit-header").height();
			$container.css({ marginTop: y + "px", height: "calc(100vh - " + y + "px)"});
		},
		
		skipParagraph: function ($el) {
            // Prune out the <p>s Confluence adds around the <span>s for the Restrict Content Macro in menus.
            // (PRESS-2055: Restrict content macro not working in menus)
            if ($el.children("p").length) {
                $child = $el.children("p").first();
                if ($child.hasClass("restricted-content-block"))
                    return $child.next();
                else if ($child.children(".restricted-content-inline").length)
                    return $child.html($child.text());
                else  return $el.children("p").first()
            }
            else return $el;
		},
		
		toggleDropdown: function (event) {
			if ($(event.target).is("li.has-dropdown")) {
				$(this).find("a").first().click();
				return false;
			}
			else if ($(event.target).is("li.no-dropdown")) {
				// TODO: Find out what AUI buttons are doing that interferes with normal click() method
				location.href = $(this).find("a").attr("href");
				return false;
			}
		}		
	};
	
	ThemePress.toFinalize(function ($) {
		ThemePress.Menu.initialize();
		ThemePress.Menu.activateExpandMacros();
		ThemePress.Menu.initializeFluidMenus();
		$(window).scroll(ThemePress.Menu.positionMenuPanels);
	});

})(jQuery);

