/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemePlugin;

public class AdminSetupDefaultsAction
extends ThemePressActionSupport {
    protected TransactionTemplate transactionTemplate;

    public String execute() throws Exception {
        try {
            BrikitThemeSettings.setupDefaults(this.getTransactionTemplate());
        }
        catch (Exception e) {
            BrikitLog.logError((String)"Could not complete Theme Press configuration.", (Exception)e);
            return this.setJSONError("<p>" + e.getMessage() + "</p>" + "<p>Please open a ticket at <a href='http://brikit.atlassian.net'>http://brikit.atlassian.net</a> if you need further support.</p>");
        }
        ThemePlugin.installBuiltInPlugins(false);
        try {
            BrikitThemeSettings.setupDemoSpaces(this.getTransactionTemplate());
        }
        catch (Exception e) {
            BrikitLog.logError((String)"Could not import Demo Space.", (Exception)e);
            return this.setJSONError("<p>" + e.getMessage() + "</p>" + "<p>Please open a ticket at <a href='http://brikit.atlassian.net'>http://brikit.atlassian.net</a> if you need further support.</p>");
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)"true");
        this.setJSONResult(json);
        return "success";
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

