(function ($) {

	ThemePress.Tabs = {
		
		anchorClicked: function () {
			var anchor = $(this).attr("href");
			if (!anchor) return;

			// If this is the tab, just update the edit focus
			var tab = $(this).closest(".menu-item.theme-press");
			if (tab.length) {
				var id = $(this).attr("href");
				ThemePress.Tabs.updateEditFocus(id);
			}
			else {
				var block = ThemePress.Tabs.blockForAnchor(anchor);
				if (!block.length) return;
				ThemePress.Tabs.clickTab(block);
				ThemePress.Tabs.updateEditFocus(block);
				return false;
			}
		},
		
		blockForAnchor: function (anchor) {
			anchor = anchor || location.hash;
			if (!anchor || anchor.length < 2) return $([]);
			var decodedAnchor = decodeURIComponent(anchor.split("#")[1]);
			decodedAnchor = ThemePress.encodeHTMLEntities(decodedAnchor);
			return $(".brikit-content-block.tabs-pane[data-anchor='" + decodedAnchor + "']");
		},

		clickTab: function (block, skipEditFocusUpdate) {
			// Click the focus block's tab, if it's in a tab arrangement and not the active tab
			if (ThemePress.Tabs.isTabbedBlock(block) && !ThemePress.Tabs.isTabbedBlockVisible(block)) {
				$(".tabs-menu li a[href='#" + $(block).attr("id") + "']").click();
				if (!skipEditFocusUpdate) ThemePress.Tabs.updateEditFocus(block);
			}
		},

		isTabbedBlock: function (block) {
			return $(block).hasClass("tabs-pane");
		},

		isTabbedBlockVisible: function (block) {
			return $(block).hasClass("active-pane");
		},

		updateEditFocus: function (block) {
			if (ThemePress.Edit.isEditMode()) ThemePress.Edit.focusBlock(block);
		}

	};

	ThemePress.toInit( function ($) {
		// Select the block named in the anchor on page load and scroll to make it visible
		var $anchorBlock = ThemePress.Tabs.blockForAnchor();
		if ($anchorBlock.length) {
			ThemePress.Tabs.clickTab($anchorBlock);
			$anchorBlock.scrollToBeVisible();
		}

		// Listen for clicks on anchors in case we need to change the focus
		$(".brikit-canvas").on("click", "a[href*=#]", ThemePress.Tabs.anchorClicked);
	});

})(jQuery);