/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.admin;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.brikit.core.comalaworkflowsservice.BlogPostPublishedEvent;
import com.brikit.core.comalaworkflowsservice.PagePublishedEvent;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.listeners.BrikitEventListener;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.util.RenderedPageCache;
import com.brikit.themepress.util.ThemePress;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class PerformanceOptimizationListener
extends BrikitEventListener {
    @Inject
    public PerformanceOptimizationListener(@ConfluenceImport EventPublisher eventPublisher) {
        super(eventPublisher);
    }

    @EventListener
    public void pageEvent(PageEvent event) {
        this.resetCache(event.getPage().getId());
    }

    @EventListener
    public void blogPostEvent(BlogPostEvent event) {
        this.resetCache(event.getBlogPost().getId());
    }

    @EventListener
    public void pagePublishedEvent(PagePublishedEvent event) {
        this.resetCache(event.getPage().getId());
    }

    @EventListener
    public void blogPostPublishedEvent(BlogPostPublishedEvent event) {
        this.resetCache(event.getBlogPost().getId());
    }

    @EventListener
    public void commentEvent(CommentEvent event) {
        AbstractPage ceo = Confluence.getPage((Comment)event.getComment());
        if (ceo != null) {
            this.resetCache(ceo.getId());
        }
    }

    @EventListener
    public void contentPermissionEvent(ContentPermissionEvent event) {
        ContentEntityObject ceo = event.getContent();
        long pageId = ceo instanceof Draft ? ((Draft)ceo).getPageIdAsLong().longValue() : ceo.getId();
        this.resetCache(pageId);
    }

    @EventListener
    public void labelEvent(LabelEvent event) {
        if (event.getLabelled() instanceof SpaceDescription) {
            ThemePress.resetCachesNonTheme();
        }
    }

    protected void resetCache(long pageId) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((long)pageId);
        if (ThemePress.isArchitectPage(abstractPage)) {
            PageWrapperCache.reset();
        }
        RenderedPageCache.resetCache();
    }
}

