(function ($) {
	
	ThemePress.Designer = false;
	if (ThemePress.Browser.mobile) return;
	
	ThemePress.Events.addEventTypes("designerModeWillChange designerModeDidChange");

	ThemePress.Designer = {
	
		on: false,
		designerInitialized: false,
		designerOpenCookie: "com.brikit.designer.open",
		designerPositionCookie: "com.brikit.designer.position",
		designerModeCookie: "com.brikit.designer.mode",
		openFieldsetsCookie: "com.brikit.designer.fieldsets.open.",
		
		accordionWillToggle: function ($toggle) {
			ThemePress.Designer.maximizeDesigner();
			return true;
		},
		
		autoSizeTextareas: function (scope) {
			var selector = scope.data("selector");
			if (!selector) return;
			$("textarea.autosizing", scope).autoSizingTextarea();
		},
	
		changeMode: function (mode, event) {

			var $tab = ThemePress.Designer.designer(".mode .mode-link[data-mode=" + mode + "]");
			if ($tab.closest("li").hasClass("active-tab")) return;

			if (!ThemePress.Events.fireCallbacks("designerModeWillChange")) return;

			ThemePress.Designer.saveMode(mode);

			// Select the tab
			AJS.tabs.change($tab, event);
			
			ThemePress.Events.fireCallbacks("designerModeDidChange");
		},
		
		changeModeFromEvent: function (event) {
			ThemePress.Designer.changeMode($(this).data("mode"), event);
			return false;
		},
		
		closeDesigner: function (callback) {
			if (ThemePress.Designer.openState()) ThemePress.Designer.stopDesigner("fast", callback);
			else callback.call();
		},
		
		controls: function () {
			return ThemePress.Designer.designer(".controls");
		},

		decodePageURL: function (href) {
			
			var page = {};
			page.path = href.substr(ThemePress.contextPath.length);
			if (page.path.indexOf("/display/") == 0) {
				var bits = page.path.split("/");
				page.key = bits[2];
				page.title = bits[3];
			}
			return page;
		},
		
		// Return the list of designable elements defined on the theme tab, or the specified selector within the designable elements
		designableElements: function (selector) {
			var elements = ThemePress.Designer.designer(".designable-element-list");
			return selector ? elements.find("[data-selector='" + selector + "']") : elements;
		},
		
		designer: function (selector) {
			var $designer = $("#designer");
			return selector ? $designer.find(selector) : $designer;
		},

		designerHolder: function (selector) {
			var $holder = $(".brikit-designer-holder");
			return selector ? $holder.find(selector) : $holder;
		},
		
		designerModeWillChange: function () {
			if (!ThemePress.Designer.designerInitialized) return;
			// Close the previously focused element, if any
			if (ThemePress.Focus.focusBlanketShowing()) ThemePress.Focus.focusedElementToggle();
		},
		
		designForm: function () {
			return ThemePress.Designer.designer(".theme-tab form.aui");
		},
		
		downloadButton: function () {
			return ThemePress.Designer.header(".download a");
		},
		
		// Reload the page, and if not noRecalculate, ensure that the reload=true parameter is in the URL
		forceReload: function (noRecalculate) {
			var href = location.href;
			if (!noRecalculate && href.indexOf("reload=true") == -1) {
				// Need to pull off anchors and add them back later
				var hashIndex = href.indexOf("#");
				var anchor = hashIndex != -1 ? href.substring(hashIndex) : "";
				if (hashIndex != -1) href = href.substring(0, hashIndex);
				href += href.indexOf("?") == -1 ? "?" : "&";
				location.href = href + "reload=true" + anchor;
			}
			else {
				location.reload(true);
			}
			return false;
		},
		
		// Display an alert dialog with message before reloading. Options are the standard alert options.
		// If not noRecalculate, ensure that the reload=true parameter is in the URL.
		forceReloadAfterAlert: function (message, options, noRecalculate) {
			options.closeWithButtonOnly = true;
			options.height = options.height || 250;
			if (message) message = "<p>" + message + "</p>";
			else message = "";
			ThemePress.Dialog2.alert(message + "<p>Click OK to reload the page.</p>", options, function () { ThemePress.Designer.forceReload(noRecalculate); });
		},

		header: function (selector) {
			var $header = $("#appheader-frame");
			return selector ? $header.contents().find(selector) : $header;
		},
		
		helpButton: function () {
			return ThemePress.Designer.header(".help a");
		},
		
		hideButton: function () {
			return ThemePress.Designer.header(".hide");
		},
		
		// Called only after the designer is loaded into the page from the server
		initializeDesignerAfterLoad: function (responseText, textStatus, XMLHttpRequest) {
			if (ThemePress.ajaxResponseError(responseText, textStatus, XMLHttpRequest, "Failed to load designer")) return;

			ThemePress.Designer.designer(".group-multi-select-search-field, .category-multi-select-search-field").change(function (event) {
				event.stopPropagation();
			});
			var accessData = { spaceKey: ThemePress.spaceKey };
			ThemePress.Designer.designer(".group-multi-select").data("properties", accessData);

			ThemePress.ThemeTab.initializeAfterLoad();
			ThemePress.ArchitectTab.initializeAfterLoad();
			ThemePress.PageTab.initializeAfterLoad();
			
			ThemePress.Designer.designerHolder().slideDown(function () {
				ThemePress.Designer.designableElements().find("textarea").autoSizingTextarea();
			});

			// Wire the designer header buttons
			ThemePress.Designer.moveButton().click(ThemePress.Designer.moveDesigner);
			ThemePress.Designer.hideButton().click(function () { ThemePress.Designer.toggleDesigner("fast"); return false; });

			// Wire the clickable popup help panel for all designer fields
			ThemePress.Designer.designer().on("click", ".help-link", ThemePress.Designer.showPopupHelp);
			
			// Wire the mode tabs
			ThemePress.Designer.designer(".mode").on("click", ".mode-link", ThemePress.Designer.changeModeFromEvent);
			
			// Select the correct mode
			var $currentModeLink = ThemePress.Designer.designer(".mode .mode-link[data-mode='" + ThemePress.Designer.mode() + "']");
			if (!$currentModeLink.length) $currentModeLink = ThemePress.Designer.designer(".mode .mode-link").first();
			$currentModeLink.click();

			// Setup the field set toggles
			ThemePress.Designer.designer(".expanding-field-set-container").fieldsetContainerToggle(true);
			
			// Wire the space autocompleters
			ThemePress.Designer.initializeSpaceAutocompleteFields();

			// Make sure any feature tours are enabled
			ThemePress.Designer.designer(".feature-tour").enableLessonPlan();

			// Make link tooltips use the fancy AUI decoration
			ThemePress.Designer.header("a[title], button[title]").tooltip({aria:true});
			ThemePress.Designer.designer("a[title], button[title]").tooltip({aria:true});

			ThemePress.Designer.designer(".group-multi-select").initializeGroupMultiSelect();
			
			ThemePress.toFinalize(ThemePress.Designer.resizeDesigner);

			// Scroll to make the the last open accordion visible  TODO: move this to individual initializers (currently has to go here to work)
			if (ThemePress.Designer.isThemeMode()) ThemePress.ThemeTab.scrollToFocusedAccordion();
			if (ThemePress.Designer.isArchitectMode()) ThemePress.ArchitectTab.scrollToFocusedAccordion();
			if (ThemePress.Designer.isPageMode()) ThemePress.PageTab.scrollToFocusedAccordion();

			// The designer is up and running
			ThemePress.Designer.designerInitialized = true;
			ThemePress.Designer.reloading = false;
			
			if (ThemePress.Designer.callbackAfterLoad) ThemePress.Designer.callbackAfterLoad.call();
			
			ThemePress.Designer.callbackAfterLoad = null;
		},
		
		// Get the space autocomplete fields wired
		initializeSpaceAutocompleteFields: function () {
			ThemePress.Designer.designer("input.autocomplete-space")
				.attr("data-max", "10")
				.attr("data-template", "{key}")
                .attr("data-none-message", AJS.I18n.getText("macro.browser.smartfields.not.found"))
				.after($("<span>").addClass("error-message"));

			AJS.Confluence.Binder.autocompleteSpace(ThemePress.Designer.designer());
		},
		
		isArchitectMode: function () {
			return ThemePress.Designer.mode() == "architect";
		},

		isPageMode: function () {
			return ThemePress.Designer.mode() == "page";
		},

		isThemeMode: function () {
			return ThemePress.Designer.mode() == "theme";
		},

		// Process hot keys for working with the designer
		keyPressed: function(event) {
			
			// Ignore keystrokes if the designer is closed
			if (!ThemePress.Designer.openState()) return;

			var keypress = event.which;
			var metaKey = event.ctrlKey || event.metaKey;
			var shiftKey = event.shiftKey;
			var altKey = event.altKey;
			var Ukey = keypress == 117 || keypress == 21; // 21 is for Chrome
			
			// Accept Shift-Ctrl-U or Shift-Command-U to redo
			if (Ukey && shiftKey && metaKey) {
				if (ThemePress.Designer.isThemeMode()) {
					if (!ThemePress.ThemeTab.redoButton().hasClass("disabled")) ThemePress.ThemeTab.redoChange();
					else ThemePress.Designer.messageUser("No Changes");
				}
				else {
					ThemePress.Designer.messageUser("Redo Unavailable");
				}
			}
			
			// Accept Ctrl-U or Command-U to undo
			// Keep the shift key test to avoid any complex combinations of the Shift keypresses that slip past the previous test
			else if (Ukey && !shiftKey && metaKey) {
				if (ThemePress.Designer.isThemeMode()) {
					if (!ThemePress.ThemeTab.undoButton().hasClass("disabled")) ThemePress.ThemeTab.undoChange();
					else ThemePress.Designer.messageUser("No Changes");
				}
				else {
					ThemePress.Designer.messageUser("Undo Unavailable");
				}
			}
			else return;

			// If we got here, then we've handled the event, so stop anything else from happening
			event.stopPropagation();
	        event.preventDefault();
		},
	
		// Return the label text displayed in the designer for the property
		labelFor: function (property) {
			return property ? ThemePress.Designer.designer("#help-" + property).text() : "";
		},
		
		loadDesigner: function (callback) {
		    if (ThemePress.PresentationMode.isPresentationMode()) { ThemePress.Designer.stopDesigner(); return; }
			if (!ThemePress.isConfluenceVersionAtLeast("6.12")) ThemePress.Designer.designerHolder(".opener").spin();
			ThemePress.Designer.callbackAfterLoad = callback;
			if (!ThemePress.Designer.reloading && ThemePress.Designer.position()) ThemePress.Designer.moveDesigner(null, true);
			ThemePress.Designer.designerHolder().load(contextPath + "/plugins/brikit/designer/load.action", {key: ThemePress.spaceKey, pageId: ThemePress.pageId}, ThemePress.Designer.initializeDesignerAfterLoad);
		},

		// Set the designer holder to the full window height. Doing this before animating state changes in the designer
		// smoothes animations.
		maximizeDesigner: function () {
			ThemePress.Designer.resizeDesigner(true);
		},
		
		// Display a slide-down short message panel to the user, and closes the message after 5 seconds
		// If needsPageReload is true, remember that and reload the page at the next auto close (but not if the user cancels the message)
		// Once the needsPageReload flag is set, only a page reload clears it.
		messageUser: function (message, needsPageReload) {
			ThemePress.Designer.messageUserCancelAutoClose();

			// If message and needsPageReload are both false, then do nothing, but reset the time until the previous message closes
			// Skip this test if the user postponed the reload so they get a reminder every time they make changes when a reload is needed
			if (!message && !needsPageReload && !ThemePress.Designer.needsPageReload) {
				ThemePress.Designer.messageUserAutoClose();
				return;
			}

			var params = {}
			var method = "generic";
			if (message) params.title = message;
			if (needsPageReload || ThemePress.Designer.needsPageReload) {
				params.body = $("#needs-page-reload").html();
				method = "warning";
			}
			var $messagePanel = $("#brikit-designer-message").empty();
			AJS.messages[method]($messagePanel, params);
			$(".icon-close", $messagePanel).unbind().click(ThemePress.Designer.messageUserCloseNow);
			$(".needs-page-reload a").click(ThemePress.Designer.forceReload);
			

    		// The ThemePress.Designer.needsPageReload test will be true if the user postponed a reload previously, so attempt to reload again
			if (needsPageReload || ThemePress.Designer.needsPageReload) {
				ThemePress.Designer.needsPageReload = "true";
			}
			$messagePanel.slideDown(ThemePress.Designer.messageUserAutoClose);
		},
		
		messageUserAutoClose: function (event) {
			// ThemePress.Designer.messageTimeout = setTimeout(ThemePress.Designer.messageUserCloseNow, 5000);
			ThemePress.Designer.messageUserCountdown(5);
			$("#brikit-designer-message .countdown").removeClass("suspended");
		},

		messageUserCancelAutoClose: function () {
			$("#brikit-designer-message .countdown").addClass("suspended");
			if (ThemePress.Designer.messageTimeout) clearTimeout(ThemePress.Designer.messageTimeout);
			ThemePress.Designer.messageTimeout = false;
		},

		messageUserCloseNow: function (event) {
			ThemePress.Designer.messageUserCancelAutoClose();

			// If we have an event, then the user clicked the close box, so don't reload the page
			if (event) ThemePress.Designer.needsPageReload = "postpone";

			if (ThemePress.Designer.needsPageReload == "true") ThemePress.Designer.forceReload();
			else $("#brikit-designer-message").slideUp();
		},
		
		messageUserCountdown: function (secondsLeft) {
			if ($("#brikit-designer-message .needs-page-reload").isHidden()) {
				ThemePress.Designer.messageTimeout = setTimeout(ThemePress.Designer.messageUserCloseNow, 5000);
			}
			else {
				secondsLeft = secondsLeft || parseInt($("#brikit-designer-message .countdown").text()) - 1;
				ThemePress.Designer.messageUserCountdownUpdate(secondsLeft);
				if (!secondsLeft) ThemePress.Designer.messageUserCloseNow();
				else ThemePress.Designer.messageTimeout = setTimeout(ThemePress.Designer.messageUserCountdown, 1100);
			}
		},
		
		messageUserCountdownUpdate: function (seconds) {
			$("#brikit-designer-message .countdown").text(seconds);
		},

		mode: function () {
			return ThemePress.cookie(ThemePress.Designer.designerModeCookie) || "page";
		},
		
		modeTabs: function () {
			return ThemePress.Designer.designer(".aui-tabs.mode .tabs-menu");
		},

		moveButton: function () {
			return ThemePress.Designer.header(".move");
		},
		
		moveDesigner: function (event, instant) {
			var speed = instant ? 0 : "fast";
			var movingLeft = ThemePress.Designer.designerHolder().hasClass("right-side");
			if (movingLeft) {
				var whereTo = ThemePress.Designer.designerHolder().offset().left;
				ThemePress.Designer.designerHolder().css({ right: "auto", left: whereTo }).animate({left: 0}, speed, function () {
					ThemePress.Designer.designerHolder().toggleClass("right-side");
				});
			}
			else {
				var whereTo = $(window).width() - ThemePress.Designer.designerHolder().outerWidth(true);
				ThemePress.Designer.designerHolder().animate({ left: whereTo }, speed, function () { 
					$(this).css({left: "auto", right: 0});
					ThemePress.Designer.designerHolder().toggleClass("right-side");
				});
			}
			ThemePress.Designer.savePosition(movingLeft);
			return false;
		},

		onlineHelpButton: function () {
			return ThemePress.Designer.header(".online-help a");
		},
		
		openAccordion: function (selector) {
			// If the selector begins with a | symbol, strip it off and left a "begins with" comparison,
			// otherwise do an exact match comparison
			var $accordion = selector.indexOf("|") == 0 ? 
				$(".accordion-switch[data-selector|='" + selector.substring(1) + "']").first() :
				$(".accordion-switch[data-selector='" + selector + "']").first();
			if (!$accordion.hasClass("closed")) return;
			$accordion.click();
		},
		
		// Mode must be "page", "architect", or "theme"
		openDesigner: function (mode, accordion, fieldset, callback) {
			var openDesignerBits = function () {
				ThemePress.Designer.changeMode(mode);
				if (accordion) ThemePress.Designer.openAccordion(accordion);
				if (fieldset) ThemePress.Designer.openFieldset(fieldset);
				if (callback) setTimeout(callback, 1000);
			}

			if (!ThemePress.Designer.openState()) ThemePress.Designer.startDesigner(false, openDesignerBits);
			else openDesignerBits();
		},
		
		openFieldset: function (toggleClass) {
			var $toggle = $(".field-set-toggle." + toggleClass).first();
			if ($toggle.fieldsetToggleIsOpen()) return;
			$toggle.click();
		},
		
		openFieldsetPanel: function (mode) {
			mode = mode || ThemePress.Designer.mode();
			var list = ThemePress.cookie(ThemePress.Designer.openFieldsetsCookie + mode);
			return list ? list.split(":::")[0] : "";
		},

		openFieldsets: function (mode) {
			mode = mode || ThemePress.Designer.mode();
			var list = ThemePress.cookie(ThemePress.Designer.openFieldsetsCookie + mode);
			return list ? list.split(":::")[1].split("+++") : [];
		},
		
		openState: function () {
			return ThemePress.Designer.designerHolder().isShowing();
		},
		
		openStateCookie: function () {
		    if (ThemePress.PresentationMode.isPresentationMode()) { ThemePress.Designer.saveOpenState(null); return null; }
			return ThemePress.cookie(ThemePress.Designer.designerOpenCookie);
		},
		
		panelForElement: function (selector) {
			return $("[data-selector='" + selector + "']", ThemePress.Designer.panels());
		},
		
		panels: function (selector) {
			var elements = ThemePress.Designer.designer(".panels");
			return selector ? elements.find("li[data-selector='" + selector + "']") : elements;
		},
	
		position: function () {
			return ThemePress.cookie(ThemePress.Designer.designerPositionCookie);
		},

		reloadDesigner: function (callback) {
			ThemePress.Designer.reloading = true;
			ThemePress.Designer.designerInitialized = false;
			$("#designer .tabs-pane > div").empty().addClass("reloading").append($("<aui-spinner class='small'>"));
			if (!ThemePress.isConfluenceVersionAtLeast("6.12")) $("#designer .tabs-pane > div").spin();
			ThemePress.Designer.loadDesigner(callback);
		},
		
		reopenFieldsets: function (scope) {
			var selector = scope.data("selector");
			if (!selector || ThemePress.Designer.openFieldsetPanel() != selector) {
				ThemePress.cookie(ThemePress.Designer.openFieldsetsCookie + ThemePress.Designer.mode(), selector + ":::");
			}
			else {
				var openSets = ThemePress.Designer.openFieldsets();
				$(".expanding-field-set-container .field-set-toggle", scope).each(function () {
					if (openSets.indexOf($(this).text()) != -1 && !$(this).closest(".expanding-field-set-container").find(".expand-control-icon.expanded").length) $(this).click();
				});
			}
			ThemePress.Designer.resizeDesigner();
		},
		
		resizeDesigner: function (fullWindowHeight) {
			if (!ThemePress.Designer.openState()) return;
			var windowHeightLessHeader = $(window).height() - ThemePress.Designer.header().outerHeight(true);
			var designerHeight = ThemePress.Designer.designer().length && !fullWindowHeight ? ThemePress.Designer.designer(".designer-contents").outerHeight(true) : windowHeightLessHeader;
			ThemePress.Designer.designer().height(Math.min(windowHeightLessHeader, designerHeight));
		},
	
		saveMode: function (mode) {
			ThemePress.cookie(ThemePress.Designer.designerModeCookie, mode);
		},
		
		saveOpenFieldsets: function (scope) {
			var selector = scope.data("selector");
			if (!selector) return;
			var openFieldsets = [];
			$(".expanding-field-set-container .expanded", scope).each(function () {
				openFieldsets.push($(this).closest(".expanding-field-set-container").find(".field-set-toggle ").text());
			});
			// Lose state after 60 minutes 
			ThemePress.cookie(ThemePress.Designer.openFieldsetsCookie + ThemePress.Designer.mode(), selector + ":::" + openFieldsets.join("+++"), 60);
		},
	
		saveOpenState: function (open) {
			// Lose state after 60 minutes 
			ThemePress.cookie(ThemePress.Designer.designerOpenCookie, open, 60);
		},
	
		savePosition: function (onLeft) {
			ThemePress.cookie(ThemePress.Designer.designerPositionCookie, onLeft ? null : "right-side");
		},
		
		shortcutsButton: function () {
			return ThemePress.Designer.header(".shortcuts a");
		},
		
		shouldReloadOnChange: function (changedElement) {
			return $(changedElement).hasClass("reload-page");
		},
		
		showPopupHelp: function () {
			// Since general click listener is on the designer, we need to wire and then fire the help popup.
			// Once the help popup is wired, it will intercept the click before the designer receives it, so this
			// only gets called once per help link.
			$(this).enablePopupHelp();
			$(this).click();
			return false;
		},
		
		startDesigner: function (speed, callback) {
			var afterStart = function () {
				ThemePress.Designer.saveOpenState("on");
				$("body").addClass("designing");
				ThemePress.Focus.updateFocusBlanket();
				ThemePress.Designer.resizeDesigner();
				if (callback) callback.call();
			};

			if (ThemePress.Designer.designer().length) {
				ThemePress.ThemeTab.structureDidChange();
				ThemePress.Designer.designerHolder().slideDown(speed, afterStart);
			}
			else {
				ThemePress.Designer.designerHolder().slideDown();
				ThemePress.Designer.loadDesigner(afterStart);
			}
		},
		
		stopDesigner: function (speed, callback) {
			var afterStop = function () {
				$("body").removeClass("designing");
				ThemePress.Designer.saveOpenState(null);
				ThemePress.Focus.updateFocusBlanket();
				if (callback) callback.call();
			};

			ThemePress.Focus.hideFocusBlanket();
			ThemePress.Designer.designerHolder().slideUp(speed, afterStop);
		},
		
		toggleDesigner: function (speed) {
		    if (ThemePress.PresentationMode.isPresentationMode()) return;

			// When the comment or rte runs, it causes extra events to fire in rapid succession.
			// Until we figure out where to stop that, just wait a bit before firing the toggle to allow the events to flood through.
			clearTimeout(ThemePress.Designer.rteBugFix);
			ThemePress.Designer.rteBugFix = setTimeout(function () {
				ThemePress.Designer.openState() ? ThemePress.Designer.stopDesigner(speed) : ThemePress.Designer.startDesigner(speed);
			}, 100);
		},
		
		uploadButton: function () {
			return ThemePress.Designer.header(".upload a");
		},
		
		// Return true if we're viewing a page (not attachments, info, etc.)
		viewMode: function () {
			return $("body.view-mode").length;
		}
		
	};

	ThemePress.toInit(function ($) {
		$("#brikit-designer-message")
			.mousemove(ThemePress.Designer.messageUserCancelAutoClose) // if mouse already over panel when it opens
			.hover(ThemePress.Designer.messageUserCancelAutoClose, ThemePress.Designer.messageUserAutoClose);
			
		// If no designer link (we're in space admin or non-space context), then add it to the admin menu
		if (!$("#brikit-designer-link").length) $("#admin-menu-link-conf-admin")
			.after($("<ul>")
				.append($("<li>")
					.append($("<a>")
						.attr("href", "/plugins/brikit/designer/load.action")
						.attr("id", "brikit-designer-link")
						.attr("rel", "nofollow")
						.attr("title", "Launch the Theme Press Designer")
							.append($("<span>").text("Theme Press Designer"))
					)
				)
			);
		
		$("#brikit-designer-link").click(function (event) {
	        ThemePress.clickOnDocument(); // This closes the system.help pulldown menu
			ThemePress.Designer.toggleDesigner("fast");
			event.preventDefault();
			event.stopPropagation();
			return false;
		});
		$(document).keypress(ThemePress.Designer.keyPressed);
		if (ThemePress.Designer.openStateCookie()) {
			ThemePress.Designer.startDesigner(0);
		}
	});
	
	ThemePress.toFinalize(function ($) {
		ThemePress.registerCookie(ThemePress.Designer.designerOpenCookie);	
		ThemePress.registerCookie(ThemePress.Designer.designerPositionCookie);	
		ThemePress.registerCookie(ThemePress.Designer.designerModeCookie);	
		ThemePress.registerCookie(ThemePress.Designer.openFieldsetsCookie);	
		
		ThemePress.Events.addCallback("designerModeWillChange", ThemePress.Designer.designerModeWillChange);
		ThemePress.Events.addCallback("designerModeDidChange", ThemePress.Designer.resizeDesigner);
		ThemePress.Events.addCallback("accordionWillToggle", ThemePress.Designer.accordionWillToggle);
	});

})(jQuery);
