/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ThemePropertiesCache {
    protected static Cache<String, ThemeProperties> cache;
    protected static CacheSettings cacheSettings;

    protected static Cache<String, ThemeProperties> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache("Brikit Theme Press Theme Properties", (CacheLoader)new ThemePropertiesCacheLoader(), cacheSettings);
        }
        return cache;
    }

    public static ThemeProperties getThemeProperties(String themeName) throws ExecutionException {
        return (ThemeProperties)ThemePropertiesCache.getCache().get((Object)themeName);
    }

    protected static void reset(String themeName) {
        ThemePropertiesCache.getCache().remove((Object)themeName);
    }

    public static void reset() {
        ThemePropertiesCache.getCache().removeAll();
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(60L, TimeUnit.MINUTES).maxEntries(100).build();
    }

    protected static class ThemePropertiesCacheLoader
    implements CacheLoader<String, ThemeProperties> {
        protected ThemePropertiesCacheLoader() {
        }

        @Nonnull
        public ThemeProperties load(@Nonnull String themeName) {
            ThemeProperties themeProperties = ExternalDevelopmentMode.isDeveloperMode() ? null : new ThemeProperties(themeName);
            return themeProperties != null ? themeProperties : new ThemeProperties(themeName);
        }
    }
}

