/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import java.util.Map;

public class ImageMapAreaMacro
extends BrikitNoBodyMacro {
    public static final String NAME = "image-map-area";
    public static final String PAGE_PARAM = "link";
    public static final String URL_PARAM = "url";
    public static final String SELECTOR_PARAM = "selector";
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/image-map-area.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        String image = macroContext.stringValue("0");
        if (image == null) {
            throw new MacroExecutionException("No image specified.");
        }
        macroContext.velocityContextAdd("image", image);
        AbstractPage attachmentPage = macroContext.pageFromValue("attachment-page", null);
        if (attachmentPage == null && macroContext.hasStringValue("attachment-page")) {
            throw new MacroExecutionException("Unable to locate the specified attachment page '" + macroContext.stringValue("attachment-page") + "'.");
        }
        if (attachmentPage == null) {
            attachmentPage = macroContext.getPage();
        }
        if (!Confluence.pageHasAttachment(attachmentPage, image)) {
            throw new MacroExecutionException("Image '" + image + "' is not found attached to the specified page '" + attachmentPage.getTitle() + "'.");
        }
        macroContext.velocityContextAdd("attachmentPage", attachmentPage);
        try {
            macroContext.handleComplexLinkValues(PAGE_PARAM, URL_PARAM, SELECTOR_PARAM, true);
        }
        catch (MacroExecutionException ex) {
            macroContext.velocityContextAdd("errorMessage", ex.getMessage());
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

