/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.admin;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.brikit.comalaworkflowsservice.BlogPostPublishedEvent;
import com.brikit.comalaworkflowsservice.PagePublishedEvent;
import com.brikit.core.confluence.Confluence;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.util.RenderedPageCache;
import com.brikit.themepress.util.ThemePress;
import org.springframework.beans.factory.DisposableBean;

public class PerformanceOptimizationListener
implements DisposableBean {
    protected EventPublisher eventPublisher;

    public PerformanceOptimizationListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageEvent(PageEvent event) {
        this.resetCache(event.getPage().getId());
    }

    @EventListener
    public void blogPostEvent(BlogPostEvent event) {
        this.resetCache(event.getBlogPost().getId());
    }

    @EventListener
    public void pagePublishedEvent(PagePublishedEvent event) {
        this.resetCache(event.getPage().getId());
    }

    @EventListener
    public void blogPostPublishedEvent(BlogPostPublishedEvent event) {
        this.resetCache(event.getBlogPost().getId());
    }

    @EventListener
    public void commentEvent(CommentEvent event) {
        AbstractPage ceo = Confluence.getPage(event.getComment());
        if (ceo != null) {
            this.resetCache(ceo.getId());
        }
    }

    @EventListener
    public void contentPermissionEvent(ContentPermissionEvent event) {
        ContentEntityObject ceo = event.getContent();
        long pageId = ceo instanceof Draft ? ((Draft)ceo).getPageIdAsLong().longValue() : ceo.getId();
        this.resetCache(pageId);
    }

    @EventListener
    public void labelEvent(LabelEvent event) {
        if (event.getLabelled() instanceof SpaceDescription) {
            ThemePress.resetCachesNonTheme();
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    protected void resetCache(long pageId) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost(pageId);
        if (ThemePress.isArchitectPage(abstractPage)) {
            PageWrapperCache.reset();
        }
        RenderedPageCache.resetCache();
    }
}

