/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.develop.ExternalDevelopmentModeSettings;
import com.brikit.core.log.BrikitLog;
import java.util.Timer;
import java.util.TimerTask;

public class ThemeDevelopmentTimeout {
    protected static final String TIMEOUT_MILLIS_KEY = "com.brikit.timeout.milliseconds";
    protected static final long TIMEOUT_MILLIS_VALUE = 43200000L;
    private static Timer timer = null;

    private static void setTimeout() {
        long interval = 43200000L;
        if (BrikitBandanaManager.getEntry(null, TIMEOUT_MILLIS_KEY) == null) {
            ThemeDevelopmentTimeout.initializeBandanaValues();
        } else {
            interval = ThemeDevelopmentTimeout.getTimeoutMillisValue();
        }
        timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ExternalDevelopmentModeSettings.enableCaches();
                BrikitLog.log("Theme Press' Theme Developer mode has been disabled due to timeout.");
            }
        }, interval);
    }

    public static void resetTimeout() {
        ThemeDevelopmentTimeout.cancelTimeout();
        ThemeDevelopmentTimeout.setTimeout();
    }

    public static void cancelTimeout() {
        if (timer != null) {
            try {
                timer.cancel();
                timer.purge();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static long getTimeoutMillisValue() {
        return Long.parseLong(BrikitBandanaManager.getEntry(null, TIMEOUT_MILLIS_KEY));
    }

    public static void setTimeoutMillisValue(long timeoutMillisValue) {
        BrikitBandanaManager.saveEntry(null, TIMEOUT_MILLIS_KEY, timeoutMillisValue > 0L ? Long.toString(timeoutMillisValue) : Long.toString(43200000L));
    }

    public static void setDefaultTimeoutMillisValue() {
        BrikitBandanaManager.saveEntry(null, TIMEOUT_MILLIS_KEY, Long.toString(43200000L));
    }

    public static void initializeBandanaValues() {
        BrikitBandanaManager.saveEntry(null, TIMEOUT_MILLIS_KEY, Long.toString(43200000L));
    }
}

