ThemePress.toInit(function ($) {

	ThemePress.Events.addEventTypes("labelsDidLoad");
	
	var $loader = $(".fetch-and-show-labels");
	
	var initLabelsEditor = function () {
        $('.show-labels-editor').click(function(e) {
            e.preventDefault();
            var target = $(e.target).closest('.labels-section-content');
            AJS.Labels.openDialog(target);
        });
		
		ThemePress.Events.fireCallbacks("labelsDidLoad");
	};
	
	var loadLabels = function (e) {
		e.preventDefault();
		$.get(ThemePress.contextPath + "/plugins/brikit/pages/loadlabels.action?pageId=" + ThemePress.pageId,
			function (result) {
				$loader.replaceWith(result);
				initLabelsEditor();
			}
		);
	}
	
	$loader.on("click", "a", loadLabels);
	
});
