/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.brikit.core.util.BrikitFile;
import com.brikit.themepress.designer.ThemePluginAccess;
import com.brikit.themepress.settings.ThemePlugin;
import java.io.File;

public class DownloadBrandPluginAction
extends ConfluenceActionSupport {
    protected String brandName;
    protected String downloadPath;

    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String execute() throws Exception {
        File zipFile = ThemePlugin.zipThemeContents(this.getBrandName());
        this.setDownloadPath(BrikitFile.prepareDownloadPath(zipFile.getPath()) + "?contentType=application/zip");
        BrikitFile.allowUserToDownload(zipFile);
        return "success";
    }

    public void validate() {
        super.validate();
        if (!ThemePluginAccess.hasThemeAccess(this.getBrandName())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }
}

