/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.upgrade;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.brikit.core.util.BrikitFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public class DiskCacheRemovalTask
implements PluginUpgradeTask {
    private static String CSS_CACHE_DIR = "css_cache";
    private static String JS_CACHE_DIR = "js_cache";
    private static String PAGE_CACHE_DIR = "page_cache";
    private static File cssCache = BrikitFile.getBrikitFile(CSS_CACHE_DIR);
    private static File jsCache = BrikitFile.getBrikitFile(JS_CACHE_DIR);
    private static File pageCache = BrikitFile.getBrikitFile(PAGE_CACHE_DIR);
    PluginSettings settings;

    public DiskCacheRemovalTask(PluginSettingsFactory pluginSettingsFactory) {
        this.settings = pluginSettingsFactory.createGlobalSettings();
    }

    public int getBuildNumber() {
        return cssCache.exists() || jsCache.exists() || pageCache.exists() ? 1 : 0;
    }

    public String getShortDescription() {
        return "Remove cache files from disk";
    }

    public Collection<Message> doUpgrade() throws Exception {
        if (cssCache.exists()) {
            BrikitFile.removeFile(cssCache);
        }
        if (jsCache.exists()) {
            BrikitFile.removeFile(jsCache);
        }
        if (pageCache.exists()) {
            BrikitFile.removeFile(pageCache);
        }
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return "com.brikit.themepress";
    }
}

