/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.servlet;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.themes.PageHelper;
import com.atlassian.spring.container.ContainerManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMobile;
import com.brikit.core.util.BrikitServletFilter;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.cache.InstantPageCache;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.profiling.RenderPerformanceProfiling;
import com.brikit.themepress.servlet.CachingHttpServletResponseWrapper;
import com.brikit.themepress.util.ThemePress;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InstantPageCachingFilter
implements Filter {
    protected static final String METADATA_LIST = "ajs-remote-user ajs-remote-user-key ajs-remote-user-has-licensed-access ajs-current-user-fullname ajs-current-user-avatar-url ajs-current-user-avatar-uri-reference ajs-user-locale ajs-atl-token ajs-user-date-pattern";
    protected static final String REFRESH_PARAM = "refreshPageCacheForPageId";
    protected static final String TOGGLE_PARAM = "setInstantPageCache";
    protected FilterConfig filterConfig = null;

    protected boolean isComalaPublished(String path) {
        return Confluence.getComala() != null && path.contains("/display/public/");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        AbstractPage abstractPage = BrikitServletFilter.getPage(httpRequest);
        PageWrapper pageWrapper = PageWrapper.get(abstractPage);
        String requestURI = httpRequest.getRequestURI();
        String refreshValue = servletRequest.getParameter(REFRESH_PARAM);
        String toggleValue = servletRequest.getParameter(TOGGLE_PARAM);
        if (BrikitString.isSet(refreshValue)) {
            abstractPage = BrikitString.isSet(refreshValue) ? Confluence.getPageOrBlogPost(refreshValue) : null;
            InstantPageCache.reset(abstractPage);
            ((HttpServletResponse)servletResponse).sendRedirect(Confluence.getContextPath() + abstractPage.getUrlPath());
            return;
        }
        if (BrikitString.isSet(toggleValue)) {
            try {
                pageWrapper.setCacheRenderedPage(BrikitBoolean.booleanValue(toggleValue));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            ((HttpServletResponse)servletResponse).sendRedirect(requestURI);
            return;
        }
        if (abstractPage == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!ThemePress.canView((ContentEntityObject)abstractPage)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (abstractPage == null || !PageWrapper.cacheRenderedPage(abstractPage)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean isComalaPublished = this.isComalaPublished(httpRequest.getRequestURI());
        if (this.isSpaceHomePage(abstractPage, requestURI)) {
            ((HttpServletResponse)servletResponse).sendRedirect(Confluence.getContextPath() + abstractPage.getUrlPath());
            return;
        }
        boolean isPhone = BrikitMobile.isPhone(httpRequest);
        Locale locale = httpRequest.getLocale();
        String cachedPage = InstantPageCache.get(abstractPage, locale, isComalaPublished, isPhone);
        if (!BrikitString.isSet(cachedPage)) {
            CachingHttpServletResponseWrapper wrapper = new CachingHttpServletResponseWrapper((HttpServletResponse)servletResponse);
            filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
            cachedPage = wrapper.toString();
            InstantPageCache.put(abstractPage, locale, isComalaPublished, isPhone, cachedPage);
        }
        Calendar start = RenderPerformanceProfiling.startTimer("Instant Page Cache rendering");
        Calendar contextStart = RenderPerformanceProfiling.startTimer("Setting up contexts");
        Map context = MacroUtils.defaultVelocityContext();
        ViewPageAction pageAction = new ViewPageAction();
        ContainerManager.autowireComponent((Object)pageAction);
        context.put("action", pageAction);
        context.put("page", abstractPage);
        context.put("pageId", abstractPage.getId());
        context.put("userAvatarUriReference", Confluence.getProfilePictureInfo().getUriReference());
        PageHelper pageHelper = new PageHelper((AbstractPageAction)pageAction);
        context.put("helper", pageHelper);
        context.put("context", abstractPage instanceof Page ? "page" : "blogpost");
        context.put("mode", "view");
        Map extendedContext = pageAction.getContext();
        String spaceKey = Confluence.getSpaceKey(abstractPage);
        extendedContext.put("spaceKey", spaceKey);
        context.put("extendedContext", extendedContext);
        context.put("brikitThemeName", SpaceWrapper.get(spaceKey).getThemeName());
        RenderPerformanceProfiling.stopTimer("Setting up contexts", contextStart);
        Calendar combinedStart = RenderPerformanceProfiling.startTimer("Render combined");
        String renderPath = "html/caching/combined.vm";
        if (!ExternalDevelopmentMode.isDeveloperMode()) {
            renderPath = "theme-press/" + renderPath;
        }
        String combined = Confluence.renderWithVelocityContext(renderPath, context);
        RenderPerformanceProfiling.stopTimer("Render combined", combinedStart);
        Calendar stringStart = RenderPerformanceProfiling.startTimer("String substitution");
        cachedPage = cachedPage.replace("<anonymous-user-placeholder>", Confluence.isAnonymousUser() ? "<meta name='anonymous-user' content='true' />" : "");
        BrikitList<String> bits = BrikitString.split(combined, ":::===:::===:::");
        cachedPage = cachedPage.replace("<common-header-placeholder>", bits.first());
        cachedPage = cachedPage.replace("<simple-toolbar-placeholder>", (CharSequence)bits.get(1));
        cachedPage = cachedPage.replace("<likes-and-labels-placeholder>", (CharSequence)bits.get(2));
        cachedPage = cachedPage.replace("<comments-placeholder>", (CharSequence)bits.get(3));
        BrikitList<String> metadataList = BrikitString.split(METADATA_LIST);
        for (String metadataName : metadataList) {
            cachedPage = cachedPage.replaceAll("<meta name=[\"']" + metadataName + "[\"'][^>]*>", "");
        }
        cachedPage = cachedPage.replace("<user-metadata-placeholder>", bits.last());
        String contentNav = (String)bits.get(4);
        contentNav = contentNav.replaceAll("<!-- putMetadata failed to add value for key \"page-id\" so rendering metadata inline - see server debug log for details -->", "");
        contentNav = contentNav.replaceAll("<meta name=['\"]ajs-page-id['\"] content=['\"]" + abstractPage.getIdAsString() + "['\"]>", "");
        contentNav = contentNav.replaceAll("\\$helper.page.id", abstractPage.getIdAsString());
        contentNav = contentNav.replaceAll("\\$helper.space.key", spaceKey);
        cachedPage = cachedPage.replace("<content-navigation-placeholder>", contentNav);
        cachedPage = cachedPage.replaceAll("<content[^>]*>", "");
        cachedPage = cachedPage.replaceAll("</content>", "");
        RenderPerformanceProfiling.stopTimer("String substitution", stringStart);
        RenderPerformanceProfiling.stopTimer("Instant Page Cache rendering", start);
        servletResponse.setContentType("text/html");
        PrintWriter out = servletResponse.getWriter();
        out.write(cachedPage);
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected boolean isSpaceHomePage(AbstractPage abstractPage, String requestURI) {
        return requestURI.endsWith("/") ? requestURI.endsWith("/display/" + abstractPage.getSpaceKey() + "/") : requestURI.endsWith("/display/" + abstractPage.getSpaceKey());
    }
}

