/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.List;

public class PageDesignRestrictions {
    protected static final String RESTRICT_PAGE_DESIGNS_SPACE_KEY = "com.brikit.themepress.restrict.page.designs";
    protected static final String RESTRICT_PAGE_LAYOUTS_SPACE_LIST_KEY = "com.brikit.themepress.restrict.page.layouts.list";
    protected static final String RESTRICT_PAGE_FRAMES_SPACE_LIST_KEY = "com.brikit.themepress.restrict.page.frames.list";

    public static BrikitList<String> pageFrameRestrictionList(Space space) {
        if (space == null) {
            return new BrikitList<String>();
        }
        return BrikitString.splitCommaSeparated(BrikitBandanaManager.getEntry(space, RESTRICT_PAGE_FRAMES_SPACE_LIST_KEY));
    }

    public static BrikitList<String> pageLayoutRestrictionList(Space space) {
        if (space == null) {
            return new BrikitList<String>();
        }
        return BrikitString.splitCommaSeparated(BrikitBandanaManager.getEntry(space, RESTRICT_PAGE_LAYOUTS_SPACE_LIST_KEY));
    }

    public static boolean restrictPageDesigns(Space space) {
        return BrikitBandanaManager.getBooleanEntry(space, RESTRICT_PAGE_DESIGNS_SPACE_KEY);
    }

    public static void savePageFrameRestrictionList(Space space, List<String> pageFrameTitles) {
        if (space == null) {
            return;
        }
        if (pageFrameTitles == null) {
            pageFrameTitles = new ArrayList<String>();
        }
        String listAsString = new BrikitList<String>(pageFrameTitles).join(",");
        BrikitBandanaManager.saveEntry(space, RESTRICT_PAGE_FRAMES_SPACE_LIST_KEY, listAsString);
    }

    public static void savePageLayoutRestrictionList(Space space, List<String> pageLayoutTitles) {
        if (space == null) {
            return;
        }
        if (pageLayoutTitles == null) {
            pageLayoutTitles = new ArrayList<String>();
        }
        String listAsString = new BrikitList<String>(pageLayoutTitles).join(",");
        BrikitBandanaManager.saveEntry(space, RESTRICT_PAGE_LAYOUTS_SPACE_LIST_KEY, listAsString);
    }

    public static void saveRestrictPageDesigns(Space space, boolean shouldRestrict) {
        if (space == null) {
            return;
        }
        BrikitBandanaManager.saveEntry(space, RESTRICT_PAGE_DESIGNS_SPACE_KEY, shouldRestrict);
    }

    public static boolean visibleToUser(Space space, Page pageDesign) {
        if (!PageDesignRestrictions.restrictPageDesigns(space)) {
            return true;
        }
        String title = pageDesign.getTitle();
        return Confluence.isConfluenceAdministrator() || Confluence.canAdministerSpace(space) || PageDesignRestrictions.pageLayoutRestrictionList(space).contains(title) || PageDesignRestrictions.pageFrameRestrictionList(space).contains(title);
    }
}

