/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrikitProperties
extends Properties {
    public BrikitProperties() {
    }

    public BrikitProperties(JSONObject jsonObject) {
        this();
        if (jsonObject == null) {
            return;
        }
        for (String key : new BrikitList(jsonObject.keys())) {
            this.put(key, jsonObject.getString(key));
        }
    }

    public static BrikitProperties readProperties(File file) {
        try {
            return BrikitProperties.readProperties(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            BrikitLog.logError("Unable to read properties from file: " + file, ex);
            return new BrikitProperties();
        }
    }

    public static BrikitProperties readProperties(InputStream inputStream) {
        BrikitProperties properties = new BrikitProperties();
        try {
            properties.load(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (IOException ex) {
            BrikitLog.logError("Unable to read properties from input stream", ex);
        }
        return properties;
    }

    public String get(String key) {
        return BrikitString.trimToNull(this.getProperty(key));
    }

    public int getInt(String key) {
        return BrikitNumber.parseInteger(this.get(key));
    }

    public long getLong(String key) {
        return BrikitNumber.parseLong(this.get(key));
    }

    public BrikitList<String> sortedKeys() {
        BrikitList<Object> keys = new BrikitList<Object>(this.keySet());
        Collections.sort(keys);
        return keys;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (Object key : this.keySet()) {
            json.put((String)key, this.get(key));
        }
        return json;
    }

    public static void updateProperty(File propertiesFile, String property, String value) throws IOException {
        String properties = BrikitFile.readFileUTF8(propertiesFile);
        if (!properties.endsWith(BrikitString.lineSeparator())) {
            properties = properties + BrikitString.lineSeparator();
        }
        if (BrikitString.isSet(value)) {
            value = value.replaceAll("[\\n\\r]+", "");
            value = value.replaceAll("\\\\", "\\\\\\\\");
        }
        String regex = "^" + property + "\\s*=[^\\n]*\\n\\r{0,1}";
        Matcher propertyMatcher = Pattern.compile(regex, 8).matcher(properties);
        String replacement = BrikitString.isSet(value) ? property + "=" + value + BrikitString.lineSeparator() : "";
        properties = propertyMatcher.find() ? propertyMatcher.replaceFirst(Matcher.quoteReplacement(replacement)) : properties + replacement;
        BrikitFile.writeFileUTF8(properties, propertiesFile);
    }
}

