/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldNames;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.search.ContentSearch;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CatalogNavigatorMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/catalog-navigator.vm";
    protected static final String SPACE_FILTER_PARAM = "space-filter";
    protected static final String SPACE_KEYS_OR_CATEGORIES_PARAM = "key";
    protected static final String LABELS_PARAM = "labels";
    protected static final String SORT_ORDER_PARAM = "sort-order";
    protected static final String SPECIFIED_KEYS_VALUE = "specified keys";
    protected static final String SORT_NAME_VALUE = "name";
    protected static final String SORT_NEWEST_VALUE = "newest";
    protected static final String SORT_OLDEST_VALUE = "oldest";
    protected static final String THUMBNAIL_HEIGHT_PARAM = "thumbnail-height";
    protected static final String THUMBNAIL_WIDTH_PARAM = "thumbnail-width";
    protected static final String THUMBNAIL_MARGIN_PARAM = "thumbnail-margin";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        SearchResults searchResults;
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        try {
            ArrayList<ContentTypeEnum> contentTypes = new ArrayList<ContentTypeEnum>();
            contentTypes.add(ContentTypeEnum.ATTACHMENT);
            String spaceFilter = macroContext.hasStringValue(SPACE_KEYS_OR_CATEGORIES_PARAM) && !macroContext.hasStringValue(SPACE_FILTER_PARAM) ? SPECIFIED_KEYS_VALUE : macroContext.stringValue(SPACE_FILTER_PARAM);
            String spaceKeysOrCategories = macroContext.stringValue(SPACE_KEYS_OR_CATEGORIES_PARAM);
            String sortParameter = macroContext.stringValue(SORT_ORDER_PARAM, SORT_NAME_VALUE);
            Object searchSort = SORT_NAME_VALUE.equalsIgnoreCase(sortParameter) ? TitleSort.ASCENDING : (SORT_NEWEST_VALUE.equalsIgnoreCase(sortParameter) ? CreatedSort.DESCENDING : CreatedSort.ASCENDING);
            searchResults = ContentSearch.searchImagesByDateAndLabel(this.getFieldsToFetch(), ContentSearch.spaceCategoryQuery(spaceFilter), ContentSearch.inSpaceQuery(spaceFilter, BrikitString.splitCommaSeparated(spaceKeysOrCategories), macroContext.getSpace().getKey()), null, ContentSearch.labelsQuery(macroContext.commaSeparatedListValue(LABELS_PARAM), true, null), ContentSearch.subsetResultFilter(0, -1), (SearchSort)searchSort);
        }
        catch (InvalidSearchException ise) {
            throw new MacroExecutionException(Confluence.getText("contentbylabel.error.run-search"), (Throwable)ise);
        }
        List searchables = Confluence.getSearchManager().convertToEntities(searchResults, SearchManager.EntityVersionPolicy.INDEXED_VERSION);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Searchable searchable : searchables) {
            if (!(searchable instanceof Attachment)) continue;
            attachments.add((Attachment)searchable);
        }
        macroContext.velocityContextAdd(THUMBNAIL_HEIGHT_PARAM, BrikitNumber.parseInteger(macroContext.stringValue(THUMBNAIL_HEIGHT_PARAM, "130")));
        macroContext.velocityContextAdd(THUMBNAIL_WIDTH_PARAM, BrikitNumber.parseInteger(macroContext.stringValue(THUMBNAIL_WIDTH_PARAM, "80")));
        macroContext.velocityContextAdd(THUMBNAIL_MARGIN_PARAM, BrikitNumber.parseInteger(macroContext.stringValue(THUMBNAIL_MARGIN_PARAM, "0")));
        macroContext.velocityContextAdd("attachments", attachments);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    protected ImmutableSet<String> getFieldsToFetch() {
        return SearchFieldNames.createWithDefaultValues((String[])new String[]{"title", "urlPath", "space-name", "created", "creatorName", "versionComment"});
    }

    public boolean isInline() {
        return true;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

