/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceExporter;
import com.brikit.themepress.util.ThemePress;
import com.google.common.io.Files;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.io.File;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;

public class ImportArchitectPagesAction
extends ThemePressActionSupport
implements ServletRequestAware {
    protected HttpServletRequest servletRequest;

    public String doDefault() {
        return "success";
    }

    @Override
    public String execute() {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            File[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                File importFile = files[i];
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log("Importing architect pages from: " + importFile.getAbsolutePath());
                if (!filename.endsWith(".zip")) {
                    this.addActionError("Architect pages must be in a .zip file.", new Object[]{filename});
                    return "error";
                }
                try {
                    File zipFile = BrikitFile.getBrikitFile("theme-press-architect-pages.zip");
                    Files.move((File)importFile, (File)zipFile);
                    SpaceExporter exporter = new SpaceExporter(zipFile, ThemePress.getThemePressDefaultSpace(), true, "theme-press-architect-pages");
                    exporter.importSpace(true);
                    continue;
                }
                catch (Exception ex) {
                    this.addActionError(BrikitString.isSet(ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename);
                    return "error";
                }
            }
        }
        ThemePress.resetCaches();
        return "success";
    }

    public MultiPartRequestWrapper getMultiPartRequest() {
        return (MultiPartRequestWrapper)this.getServletRequest();
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

