(function ($) {
	
	if (ThemePress.Browser.mobile) return;

	ThemePress.ArchitectTab = {
		
		designerFocusCookie: "com.brikit.designer.architect.focus",

        // Adds an element defined by the fields data-element to the Architect Tab in the designer.
		addElement: function (event) {

			event.stopPropagation();
			event.preventDefault();
			
            var href = $(this).attr("href");
			var element = $(this).data("element")

            // Finds the value for the field with the name 'elementType' + '-name' starting from the latest 'field-group' element.
            href += "&name=" + encodeURIComponent($(this).closest(".expanding-field-set-container").find("." + element + "-name").val());

            // Creates a JSON response.
            $.post(href, ThemePress.ArchitectTab.architectPageCreateResponse, "json");

            // Returns 'false' so that the browser does not navigate to the location (loads in place).
            return false;
         },

 		previewFrame: function (event) {
 			event.preventDefault();
			var pageTitle = $(this).closest(".radio").find("input.radio").data("page-title");
			$.get(ThemePress.contextPath + "/plugins/brikit/architect/previewframe.action", { "framePageTitle": pageTitle }, ThemePress.ArchitectTab.displayPreview);
 			return false;
 		},
		
		displayPreview: function (data, textStatus, jqXHR) {
			alert(data);
            // if (data.success) ThemePress.Dialog2.alert(data);
            // else ThemePress.Dialog2.alert("<p>" + data.message + "</p>");
        },

        // Adds the 'Menu' option to the architect tab.
        addMenu: function () {

			var data = {};
			
            var $typeSelection = $(this).closest("fieldset.group").find(".menu-type .aui-button[aria-pressed='true']");
			data[$typeSelection.data("menu-style")] = "true";

            data.name = $(this).closest("fieldset.group").find(".menu-name").val();

			// Creates a JSON response.
            $.post($(this).attr("href"), data, ThemePress.ArchitectTab.architectPageCreateResponse, "json");

            // Returns 'false' so that the browser does not navigate to the location (loads in place).
            return false;
        },

		architectDesigner: function (selector) {
			var elements = ThemePress.Designer.designer(".architect-element-list");
			return selector ? elements.find(selector) : elements;
		},

        architectPageChange: function (data, textStatus, jqXHR) {
            if (data.success) ThemePress.Designer.forceReload(true);
            else ThemePress.Dialog2.alert("<p>" + data.message + "</p>");
        },
		
		architectPageCreateResponse: function (data, textStatus, jqXHR) {
			if (data.success) location.href = data.url;
			else ThemePress.Dialog2.alert("<p>" + data.message + "</p>");
		},

		// Return the list of layout elements defined on the layout tab.
		architectElements: function (selector) {
			var elements = ThemePress.Designer.designer(".architect-element-list");
			return selector ? elements.find("[data-selector='" + selector + "']") : elements;
		},
		
		autoSizeTextareas: function () {
			if (ThemePress.Designer.isArchitectMode()) ThemePress.Designer.autoSizeTextareas(ThemePress.ArchitectTab.focusedElementToggle());
		},
		
		designerModeWillChange: function () {
		},
		
		elementSelector: function (element) {
			return $(element).data("selector");
		},

        // Download.
		exportPages: function () {
			var href = ThemePress.contextPath + "/plugins/brikit/architect/export.action";
			var $form = $("<form>").attr("id", "temp-export-pages-form").attr("action", href).css({display: "none"});
			var $selected = ThemePress.ArchitectTab.architectElements().find("#architect-page-multi-select .checkbox:checked");
			if (!$selected.length) {
			    // TODO: i18n this line.
				ThemePress.Dialog2.alert("<p>No pages are selected.</p>", {title: "Can't Export"});
				return false;
			}
			$selected.each(function () {
				var title = $(this).data("page-title");
				var $input = $("<input>").attr("type", "text").attr("name", "titles").attr("value", title);
				$form.append($input);
			});
			$("#temp-export-pages-form").remove();
			$("body").append($form);
			$form.submit();
			return false;
		},

		focus: function () {
			if (!ThemePress.Designer.openState()) return;

			if ($(this).hasClass("closed") || $(this).closest(".accordion-switch").hasClass("closed")) {
				ThemePress.ArchitectTab.saveFocusState(null);
			}
			else {
				var selector = ThemePress.ArchitectTab.elementSelector(this);
				var $selected = $(".designable[data-selector='" + selector + "']").first();
				ThemePress.ArchitectTab.saveFocusState(selector);
			}
	    },
	
		focusedElementToggle: function () {
			return ThemePress.ArchitectTab.architectElements(ThemePress.ArchitectTab.focusState());
		},
	
		focusState: function () {
			return ThemePress.cookie(ThemePress.ArchitectTab.designerFocusCookie);
		},

		// Upload.
		importPages: function () {
			var $button = ThemePress.ArchitectTab.architectElements().find(".manage-architect-pages .upload-pages");
			AJS.InlineDialog(
				$button, 
				"importPages" + new Date().getTime(),
				ThemePress.contextPath + "/plugins/brikit/architect/import.action", 
				{
					onHover: false, 
					width: 500, 
					showDelay: 0, 
					initCallback: function () {
						var $popup = $(this.popup);
						$popup.css({zIndex: 10000});
						
						// Make the file upload form work via ajax (using the jquery.form plugin).
						$("#architect-pages-uploader").ajaxForm(function (result) {
							if ($(result).hasClass("errorMessage")) ThemePress.Dialog2.alert(result, { title: "Error Importing Pages" });
							else ThemePress.Designer.forceReload();
						});

						var $form = $("form.uploader", $popup);
						var $fileField = $(".upfile", $form);
						// When the file upload filename changes, automagically upload and apply the file to the current image field.
						$fileField.change(function () {
							var filename = $(".upfile", $form).val().split('\\').pop();
							ThemePress.Dialog2.confirm("<p>Import the architect pages in <strong>" + filename + "</strong>?</p>", { title: "Import Pages", size: "small" }, function () { $form.closest("form.uploader").submit(); }, function () { $fileField.val(""); });
						});
					}
				}
			);
			return false;
		},
		
		// Called only after the designer is loaded into the page from the server.
		initializeAfterLoad: function (speed) {

			// Set up accordion elements.
			ThemePress.ArchitectTab.architectElements()

				// Turn on the accordion feature of the list so that only one element is open at a time.
				.brikitAccordion(false, true, ".clickable-control", ".designer-panel", function () { $(this).find(".designer-panel textarea").autoSizingTextarea(); })
				.accordionSpeed("fast");

			// Make each accordion element click to focus the designer on it.
			ThemePress.ArchitectTab.architectElements().find(".clickable-control").each(function () {
				$(this).click(ThemePress.ArchitectTab.focus);
				var selector = ThemePress.ArchitectTab.elementSelector(this);
				$(selector)
					.addClass("designable")
					.attr("data-selector", selector);
			});

			// Open the accordion element that was last open (if any).
			ThemePress.ArchitectTab.architectElements(ThemePress.ArchitectTab.focusState()).click();

			// Wire the override site theme buttons.
			ThemePress.Designer.designer(".site-theme-selector .aui-button").click(ThemePress.ArchitectTab.useDefaultThemeChanged);
			
			// Wire the space logo target field.
			ThemePress.ArchitectTab.respondToUserEdits("#brikitLogoTargetSpaceKey", ThemePress.ArchitectTab.spaceLogoTargetChanged)
				.bind("selected.autocomplete-content", ThemePress.ArchitectTab.spaceLogoTargetChanged);
				
			// Wire the logo position fields
			ThemePress.ArchitectTab.respondToUserSpaceLogoEdits("#brikitSpaceLogoVerticalPosition");
			ThemePress.ArchitectTab.respondToUserSpaceLogoEdits("#brikitSpaceLogoVerticalMargin");
			ThemePress.ArchitectTab.respondToUserSpaceLogoEdits("#brikitSpaceLogoHorizontalPosition");
			ThemePress.ArchitectTab.respondToUserSpaceLogoEdits("#brikitSpaceLogoHorizontalMargin");
			ThemePress.ArchitectTab.respondToUserSpaceLogoEdits("#brikitSpaceLogoHeight");
			ThemePress.ArchitectTab.respondToUserSpaceLogoEdits("#brikitSpaceLogoWidth");
			
            // Set up the architect page selectors.
			ThemePress.ArchitectTab.architectDesigner(".space-architect-default-selector").on("click", ".aui-button", ThemePress.ArchitectTab.overrideDefaultArchitectPageChanged);
            ThemePress.ArchitectTab.architectDesigner(".architect-source-select input.radio").click(ThemePress.ArchitectTab.selectArchitectPage);
            // ThemePress.ArchitectTab.architectDesigner(".architect-source-select").on("click", ".view-page-link", ThemePress.ArchitectTab.previewFrame);

            ThemePress.ArchitectTab.architectElements().on("click", ".menu-type .aui-button", ThemePress.ArchitectTab.menuTypeChanged);
            ThemePress.ArchitectTab.architectElements().on("click", ".add-menu", ThemePress.ArchitectTab.addMenu);
            // Ensure that a function is being passed and not the result.
			
            ThemePress.ArchitectTab.architectElements().on("click", ".add-layout, .add-template, .add-header, .add-footer, .add-banner", 
				function (event) {
					ThemePress.ArchitectTab.addElement.call(this, event); 
				}
			);
			
			// Prevent pressing Return from firing anything from the create architect page name fields.
			ThemePress.ArchitectTab.architectElements().on("keypress", ".create-architect-page-name-field", ThemePress.ArchitectTab.swallowReturns);
			
            const clearAll = function () {
				$("#architect-page-multi-select .architect-source-select .checkbox").removeAttr("checked");
			};
            
            const selectAll = function () {
				$("#architect-page-multi-select .architect-source-select .checkbox").attr("checked", "checked");
			};
            
            const selectBuiltIns = function () {
				clearAll();
                [
                    ".brikit.banner.Empty",
                    ".brikit.banner.Maintenance",
                    ".brikit.footer.Splash Demo",
                    ".brikit.footer.Vanilla Demo",
                    ".brikit.header.Empty",
                    ".brikit.layout.Announcement",
                    ".brikit.layout.Basic Confluence",
                    ".brikit.layout.Community",
                    ".brikit.layout.Documentation",
                    ".brikit.layout.Landing Page",
                    ".brikit.menu.Splash Demo",
                    ".brikit.menu.Vanilla Demo",
                ].forEach(function (title) {
                    $("#architect-page-multi-select .architect-source-select .checkbox[data-page-title='" + title + "']").attr("checked", "checked");
                });
			};
            
			// Set up the download/upload panel.
			ThemePress.ArchitectTab.architectElements().find(".manage-architect-pages .download-pages").click(ThemePress.ArchitectTab.exportPages);
			ThemePress.ArchitectTab.architectElements().find(".manage-architect-pages .upload-pages"  ).each(ThemePress.ArchitectTab.importPages);
			ThemePress.ArchitectTab.architectElements().find(".manage-architect-page-selections .select-built-ins").click(selectBuiltIns);
			ThemePress.ArchitectTab.architectElements().find(".manage-architect-page-selections .select-all").click(selectAll);
			ThemePress.ArchitectTab.architectElements().find(".manage-architect-page-selections .clear-all").click(clearAll);
			
        },
		
        menuTypeChanged: function () {
            if ($(this).attr("aria-pressed")) return false;
            $(this).closest(".menu-type").find(".aui-button").removeAttr("aria-pressed");
            $(this).attr("aria-pressed", "true");
            return false;
        },
		
		overrideDefaultArchitectPageChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			$(this).closest(".space-architect-default-selector").find(".aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			location.href = ThemePress.contextPath + "/plugins/brikit/architect/setoverridedefault.action?pageId=" + ThemePress.pageId + "&architectPageTitle=" + $(this).data("architect-page") + "&overrideDefault=" + ($(this).data("setting") == "override");
			return false;
		},

		reopenFieldsets: function () {
			if (ThemePress.Designer.isArchitectMode()) ThemePress.Designer.reopenFieldsets(ThemePress.ArchitectTab.focusedElementToggle());
		},
		
		resizeDesigner: function () {
			if (ThemePress.Designer.isArchitectMode()) ThemePress.Designer.resizeDesigner();
		},
		
		respondToUserEdits: function (selector, callback) {
			return ThemePress.ArchitectTab.architectDesigner(selector)
				.keypress(function (event) { 
					if (event.which == 13) {
						event.preventDefault();
						callback.call(this);
					}
				})
				.change(callback);
		},
		
		respondToUserSpaceLogoEdits: function (selector) {
			ThemePress.ArchitectTab.respondToUserEdits(selector, ThemePress.ArchitectTab.spaceLogoAttributeChanged);
		},
		
		saveFocusState: function (selector) {
			// Lose state after 60 minutes.
			ThemePress.cookie(ThemePress.ArchitectTab.designerFocusCookie, selector, 60);
		},
		
		saveOpenFieldsets: function () {
			if (ThemePress.Designer.isArchitectMode()) ThemePress.Designer.saveOpenFieldsets(ThemePress.ArchitectTab.focusedElementToggle());
		},
		
		scrollToFocusedAccordion: function () {
			if (ThemePress.ArchitectTab.focusState()) ThemePress.ArchitectTab.architectElements(ThemePress.ArchitectTab.focusState()).scrollToBeVisible(ThemePress.Designer.designerHolder());
		},

        selectArchitectPage: function () {
            var href = $(this).attr("href");
            var data = {pageId: ThemePress.pageId, architectPageTitle: $(this).attr("name"), selected: $(this).data("page-title")};

			var demoSpaceMenu = $(this).attr("name") == ".brikit.menu." && ThemePress.isDemoSpace;
			var message = demoSpaceMenu ? "<p><strong>WARNING: Changing the demo space menu will break some of the tour guides.</strong></p>" : "";
			var height = demoSpaceMenu ? 220 : 200;
			message += "<p>Change " + $(this).attr("archSourceType") + " to " + $(this).attr("archSourceName") + "?</p>";
            ThemePress.Dialog2.confirm(message, { title: "Change Source", size: "small" }, function (dialog) {
                dialog.hide();

                $.post(href, data, ThemePress.ArchitectTab.architectPageChange, "json");
            });

            return false;
        },

		spaceLogoAttributeChanged: function () {
			var attribute = $(this).attr("name");
			var data = { spaceKey: ThemePress.spaceKey, selector: $(this).attr("id") };
			data[attribute] = $(this).val();
			$.post(ThemePress.contextPath + "/plugins/brikit/architect/set" + attribute.toLowerCase() + ".action", data, ThemePress.ArchitectTab.reloadOrDisplayError, "json");
		},
		
		spaceLogoTargetChanged: function () {
			// Wait a bit before firing to allow for both manual changes and click-on-autocomplete actions without firing multiple sectors.
			clearTimeout(ThemePress.ArchitectTab.logoTargetSpaceKeyChanging);
			var data = { spaceKey: ThemePress.spaceKey, logoTargetSpaceKey: $(this).val(), selector: $(this).attr("id") };
			ThemePress.ArchitectTab.logoTargetSpaceKeyChanging = setTimeout(function () {
				$.post(ThemePress.contextPath + "/plugins/brikit/architect/setspacelogotarget.action", data, ThemePress.ArchitectTab.reloadOrDisplayError, "json");
			}, 300);
		},
		
		spaceLogoTargetChangedWithReturn: function (event) {
			var keypress = event.which;
			if (keypress == 13) {
				ThemePress.ArchitectTab.spaceLogoTargetChanged.call(this);
				return false;
			}
		},
		
		reloadOrDisplayError: function (data, textStatus, XMLHttpRequest, alertTitle) {
			if (data.success) {
				ThemePress.Designer.forceReload();
			}
			else {
				$("#error-" + data.selector).show().attr("title", data.message).tooltip({aria:true});
			}
		},
		
		swallowReturns: function (event) {
			var keypress = event.which;
			if (keypress == 13) {
				return false;
			}
		},
		
		useDefaultThemeChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			ThemePress.Designer.designer(".site-theme-selector .aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");

			location.href = ThemePress.contextPath + "/plugins/brikit/theme/usesitetheme.action?pageId=" + ThemePress.pageId + "&useSiteTheme=" + ($(this).data("theme") == "default");
			return false;
		}

	};
	
	ThemePress.toInit( function ($) {	
		ThemePress.registerCookie(ThemePress.ArchitectTab.designerFocusCookie);	

		ThemePress.Events.addCallback("designerModeWillChange", ThemePress.ArchitectTab.designerModeWillChange);
		ThemePress.Events.addCallback("accordionDidToggle", ThemePress.ArchitectTab.reopenFieldsets);
		ThemePress.Events.addCallback("accordionDidToggle fieldsetContainerToggled", ThemePress.ArchitectTab.saveOpenFieldsets);
		ThemePress.Events.addCallback("accordionDidToggle fieldsetContainerToggled", ThemePress.ArchitectTab.autoSizeTextareas);
		ThemePress.Events.addCallback("fieldsetContainerToggled", ThemePress.ArchitectTab.resizeDesigner);
	});

})(jQuery);
