/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.model.PageWrapper;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class PageWrapperCache {
    protected static Cache<String, PageWrapper> cache;
    protected static CacheSettings cacheSettings;

    protected static String cacheKey(AbstractPage abstractPage) {
        return PageWrapperCache.cacheKey(abstractPage.getIdAsString(), abstractPage.getVersion(), Confluence.canEdit(abstractPage));
    }

    protected static String cacheKey(String pageIdAsString, int pageVersion, boolean canEdit) {
        return pageIdAsString + ":" + pageVersion + ":" + canEdit;
    }

    protected static Cache<String, PageWrapper> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache("Brikit Theme Press Page Wrappers", (CacheLoader)new PageWrapperCacheLoader(), cacheSettings);
        }
        return cache;
    }

    public static PageWrapper getPageWrapper(AbstractPage abstractPage) throws ExecutionException {
        String cacheKey = PageWrapperCache.cacheKey(abstractPage);
        PageWrapper wrapper = (PageWrapper)PageWrapperCache.getCache().get((Object)cacheKey);
        return wrapper;
    }

    protected static String pageIdFromKey(String cacheKey) {
        return new BrikitList<String>((List<String>)BrikitString.split(cacheKey, ":")).first();
    }

    public static void reset() {
        PageWrapperCache.getCache().removeAll();
    }

    public static void reset(AbstractPage abstractPage) {
        PageWrapperCache.getCache().remove((Object)PageWrapperCache.cacheKey(abstractPage));
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(60L, TimeUnit.MINUTES).maxEntries(10000).build();
    }

    protected static class PageWrapperCacheLoader
    implements CacheLoader<String, PageWrapper> {
        protected PageWrapperCacheLoader() {
        }

        @Nonnull
        public PageWrapper load(@Nonnull String cacheKey) {
            String pageIdAsString = PageWrapperCache.pageIdFromKey(cacheKey);
            return new PageWrapper(pageIdAsString);
        }
    }
}

