(function ($) {
	
	ThemePress.Focus = false;
	if (ThemePress.Browser.mobile) return;

	ThemePress.Focus = {

		focusBlanket: function () {
			return $(".focus-blanket");
		},
		
		focusBlanketShowing: function () {
			return ThemePress.Focus.focusBlanket().length;
		},
		
		focusElementIdNamedInAnchor: function () {
			
	        var loc = window.location.toString();

			// Nothing if no focused element id is found
			if (loc.indexOf("#") == -1) return false;

			// Dump everything up to and including the hash
	        loc = loc.split("#")[1];

			// Ignore any URL parameters
			if (loc.indexOf("?") != -1) loc = loc.split("?")[0];

            loc = encodeURIComponent(loc);
			
			// What's left is the element Id. See if it matches any layer, column, or block on the page.
			var element = $("#content-layer-" + loc + ",#content-column-" + loc + ",#content-block-" + loc);
			if (element.length) {
				ThemePress.PageTab.saveFocusState("#" + element.attr("id"));
				loc = window.location.toString();
				window.location = loc.substring(0, loc.indexOf("#"));
			}
			
		},

		focusedElement: function () {
			if (ThemePress.Designer.isThemeMode()) return $(ThemePress.ThemeTab.focusedElement()).first();
			if (ThemePress.Designer.isPageMode()) return $(ThemePress.PageTab.focusedElement()).first();
			return null;
		},
		
		focusedElementToggle: function () {
			if (ThemePress.Designer.isThemeMode()) ThemePress.ThemeTab.focusedElementToggle().click();
			if (ThemePress.Designer.isPageMode()) ThemePress.PageTab.focusedElementToggle().click();
			return false;
		},

		hideFocusBlanket: function () {
			$(".focus-blanket-target").removeClass("focus-blanket-target");
			ThemePress.Focus.focusBlanket().remove();
		},
		
		showFocusBlanket: function (element) {
			var updating = !element;
			var $element = element ? $(element).first() : ThemePress.Focus.focusedElement();
			var hidden = !$element || $element.isHidden();
			if (!updating || hidden) ThemePress.Focus.hideFocusBlanket();
			if (!$element || !$element.length || hidden) return ThemePress.Focus.hideFocusBlanket();

			var docWidth = $("#full-height-container").width();
			var docHeight = $(".ia-splitter").height();

			var offset = $element.offset();
			var $confluence = $("#brikit-confluence-holder");
			offset.top  += $confluence.scrollTop();
			offset.left += $confluence.scrollLeft();
			
			var width = $element.outerWidth();
			var height = $element.outerHeight();
			var bottom = offset.top + height;

			if (!$(".focus-blanket").length) {
				var $topBlanket = $("<div>").addClass("focus-blanket top");
				var $leftBlanket = $("<div>").addClass("focus-blanket left");
				var $rightBlanket = $("<div>").addClass("focus-blanket right")
				var $bottomBlanket = $("<div>").addClass("focus-blanket bottom");
				$("#full-height-container").append($topBlanket, $leftBlanket, $rightBlanket, $bottomBlanket);
				$(".focus-blanket").click(ThemePress.Focus.focusedElementToggle);
			}
			$(".focus-blanket.top"   ).css({top: 0, left: 0, width: docWidth, height: offset.top});
			$(".focus-blanket.left"  ).css({top: offset.top, width: offset.left, height: height});
			$(".focus-blanket.right" ).css({top: offset.top, left: offset.left + width, width: Math.max(0, docWidth - offset.left - width), height: height});
			$(".focus-blanket.bottom").css({top: bottom, left: 0, width: docWidth, height: Math.max(0, docHeight - bottom)});
			if (!$element.hasClass("focus-blanket-target")) {
				$element.addClass("focus-blanket-target");
				$element.scrollToBeVisible($confluence);
			}
		},
		
		updateFocusBlanket: function () {
			if (!ThemePress.Designer.openStateCookie() || !ThemePress.Designer.viewMode()) return ThemePress.Focus.hideFocusBlanket();
			ThemePress.Designer.designerHolder().show();
			ThemePress.Designer.resizeDesigner();
			ThemePress.Focus.showFocusBlanket();
		}

	};
	
	ThemePress.toInit( function ($) {
		ThemePress.Focus.focusElementIdNamedInAnchor();
	});

})(jQuery);

