/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitString;
import java.util.Map;

public class RolloverImageLinkMacro
extends BrikitNoBodyMacro {
    public static final String NAME = "rollover-image-link";
    public static final String PAGE_PARAM = "link";
    public static final String URL_PARAM = "url";
    public static final String SELECTOR_PARAM = "selector";
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/rollover-image-link.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (!macroContext.hasStringValue("image")) {
            throw new MacroExecutionException("No image specified.");
        }
        AbstractPage attachmentPage = macroContext.pageFromValue("page", macroContext.getPage());
        macroContext.velocityContextAdd("page", attachmentPage);
        String imageName = macroContext.stringValue("image");
        if (!Confluence.pageHasAttachment(attachmentPage, imageName)) {
            throw new MacroExecutionException(imageName + " not found on " + attachmentPage);
        }
        String hoverName = macroContext.stringValue("hover");
        if (BrikitString.isSet(hoverName) && !Confluence.pageHasAttachment(attachmentPage, hoverName)) {
            throw new MacroExecutionException(hoverName + " not found on " + attachmentPage);
        }
        macroContext.handleComplexLinkValues(PAGE_PARAM, URL_PARAM, SELECTOR_PARAM, true);
        macroContext.velocityContextAdd("imageHeight", macroContext.pixelSize("height"));
        macroContext.velocityContextAdd("imageWidth", macroContext.pixelSize("width"));
        macroContext.velocityContextAdd("height", null);
        macroContext.velocityContextAdd("width", null);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

