/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.html;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class BrikitHTML {
    public static Document getDocument(String url) {
        try {
            Connection connection = Jsoup.connect((String)url).ignoreContentType(true).followRedirects(true).userAgent("Mozilla/5.0 facebookexternalhit/1.1 Facebot Twitterbot/1.0 Slackbot-LinkExpanding 1.0 (+https://api.slack.com/robots)");
            if (url.startsWith(Confluence.getBaseUrl())) {
                connection.cookies(Confluence.getCookieMap());
            }
            return connection.get();
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to read URL: " + url);
            return null;
        }
    }

    public static Document getDocumentFromHtml(String html) {
        return Jsoup.parse((String)html);
    }

    public static String getHostName(String url) {
        String noProtocol = BrikitString.split(url, "://").last();
        String noQuery = BrikitString.split(noProtocol, "\\?").first();
        String noAnchor = BrikitString.split(noQuery, "#").first();
        String hostOnly = BrikitString.split(noAnchor, "/").first();
        String noPort = BrikitString.split(hostOnly, ":").first();
        return noPort;
    }

    public static String getProtocol(String url) {
        return url.contains("://") ? BrikitString.split(url, "//").first() : "";
    }

    public static Elements getElements(String html, String selector) {
        return BrikitHTML.getElements(BrikitHTML.getDocumentFromHtml(html), selector);
    }

    public static Elements getElements(Document document, String selector) {
        return document == null ? new Elements() : document.select(selector);
    }

    public static Elements getElementsFromUrl(String url, String selector) {
        return BrikitHTML.getElements(BrikitHTML.getDocument(url), selector);
    }

    public static String getValue(String url, String selector, String attribute) {
        return BrikitHTML.getValue(BrikitHTML.getDocument(url), selector, attribute);
    }

    public static String getValue(Document document, String selector, String attribute) {
        Elements elements = BrikitHTML.getElements(document, selector);
        return elements.isEmpty() ? "" : elements.first().attr(attribute);
    }

    public static String getText(String url, String selector) {
        return BrikitHTML.getText(BrikitHTML.getDocument(url), selector);
    }

    public static String getText(Document document, String selector) {
        Elements elements = BrikitHTML.getElements(document, selector);
        for (Element element : elements) {
            if (!BrikitString.isSet(element.text())) continue;
            return element.text();
        }
        return "";
    }

    public static String getTextFromHtml(String html, String selector) {
        return BrikitHTML.getText(BrikitHTML.getDocumentFromHtml(html), selector);
    }

    public static String getMeta(String url, String name) {
        return BrikitHTML.getMeta(BrikitHTML.getDocument(url), name);
    }

    public static String getMeta(Document document, String ... tags) {
        for (String tag : tags) {
            String content = BrikitHTML.getMetaTagNameOrProperty(document, tag);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    public static String getMetaTagNameOrProperty(Document document, String tag) {
        String content = BrikitHTML.getMetaTag(document, "name", tag);
        if (!BrikitString.isSet(content)) {
            content = BrikitHTML.getMetaTag(document, "property", tag);
        }
        return content;
    }

    public static String getMetaTag(Document document, String type, String tag) {
        String content;
        if (document == null || type == null || tag == null) {
            return null;
        }
        Elements elements = document.select("meta[" + type + "='" + tag + "']");
        if (!elements.isEmpty() && BrikitString.isSet(content = elements.first().attr("content"))) {
            return content;
        }
        return null;
    }
}

