/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.LastLocalSafeIdCache;
import java.util.Calendar;
import java.util.Date;

public class SafeId {
    protected static String lastSafeId = "0";
    protected static final long ONE_DAY_IN_MILLISECONDS = 86400000L;
    protected static final long ONE_DAY_IN_CENTISECONDS = 8640000L;
    protected static Calendar baseDate;

    public static Calendar getBaseDate() {
        if (baseDate == null) {
            baseDate = Calendar.getInstance();
            baseDate.clear();
            baseDate.setTimeZone(Confluence.getSystemTimeZone().getWrappedTimeZone());
            baseDate.set(2018, 7, 13);
        }
        return baseDate;
    }

    protected static String getLastSafeId() {
        return lastSafeId;
    }

    @Deprecated
    public static String safeId() {
        return SafeId.safeId("");
    }

    @Deprecated
    public static String safeId(String root) {
        return SafeId.globalSafeId(root);
    }

    public static String globalSafeId() {
        return SafeId.globalSafeId("");
    }

    public static String globalSafeId(String root) {
        return SafeId.globalSafeId(root, SafeId.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String globalSafeId(String root, Object lockObject) {
        Object object = lockObject;
        synchronized (object) {
            String safeId = SafeId.generateId();
            while (safeId.equals(SafeId.getLastSafeId())) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                safeId = SafeId.generateId();
            }
            SafeId.setLastSafeId(safeId);
            return root + String.valueOf(safeId);
        }
    }

    public static String localSafeId() {
        return SafeId.localSafeId("");
    }

    public static String localSafeId(String root) {
        String username = BrikitString.isSet(Confluence.getUsername()) ? Confluence.getUsername() : "anonymous";
        Integer localSafeId = LastLocalSafeIdCache.getLastLocalSafeId(username) + 1;
        SafeId.setLastLocalSafeId(username, localSafeId);
        return root + localSafeId;
    }

    protected static void setLastLocalSafeId(String username, Integer localSafeId) {
        LastLocalSafeIdCache.getCache().put((Object)username, (Object)localSafeId);
    }

    protected static String generateId() {
        long id = BrikitNumber.longValue(Integer.toString(BrikitDate.daysBetween(SafeId.getBaseDate(), Calendar.getInstance())) + Long.toString(new Date().getTime() % 8640000L));
        return Integer.toString((int)(id % Integer.MAX_VALUE));
    }

    protected static void setLastSafeId(String safeId) {
        lastSafeId = safeId;
    }
}

