(function ($) {
	
	BrikitLiveEditor = function (block) {
		this.block = $(block);
		this.blockId = this.block.data("content-block");
		this.block.data("live-editor", this);
		this.offsetParent = this.block.offsetParent();
		this.position = this.offsetParent.position();
		this.addEditControls();
	};
	
	Object.assign(BrikitLiveEditor.prototype, {
		
		activate: function (options) {
			var self = this;
			$("body").addClass("live-editing");
			var editorHeight = Math.max(200, this.block.height());
			this.block.after(this.getContainer()).hide();
			var defaultOptions = {
				$container: this.getContainer(),
				$form: this.getForm(),
				toolbar: { 
					Tasks: false, 
					Insert: false,
					PageLayouts: false, 
					SearchReplace: false, 
					Help: false
				},
				fetchContent: this.editBlockContent(),
				onInitialise: function () {
					self.getContainer().find("#rte").height(editorHeight);
					self.getContainer().find("#wysiwyg").css({
						boxSizing: "border-box",
						paddingLeft:  self.block.css("padding-left"),
						paddingRight: self.block.css("padding-right")
					});
				},
				postInitialise: function () {
					AJS.Meta.set("content-type", self.contentType);
				},
				saveHandler: this.save.bind(this),
				cancelHandler: this.cancel.bind(this)
			}
			
			// Confluence needs to believe this page is a commment or it move the breadcrumbs to the editor (removes from the page)
			// After the editor initializes, it's put back to the original content type
			this.contentType = AJS.Meta.get("content-type");
			AJS.Meta.set("content-type", "comment");
			
			var editor = AJS.Confluence.QuickEdit.activateEditor($.extend(defaultOptions, options));
			return editor;
		},
		
		addEditControls: function () {
			ThemePress.Edit.initialize();
		},
		
		cancel: function (e) {
			e.preventDefault();
			this.deactivate();
		},
		
		deactivate: function (callback) {
			var self = this;
			ThemePress.clickCanvas();
			AJS.Confluence.QuickEdit.deactivateEditor().done(function () {
				self.getContainer().remove();
				self.block.show();
				if (callback) callback.call();
			});
			$("body").removeClass("live-editing");
		},
		
		editBlockContent: function () {
			var self = this;
			var responseDeferred = new $.Deferred();
			
			$.ajax({
				url: ThemePress.contextPath + "/plugins/brikit/pages/editblockcontent.action",
				data: { pageId: ThemePress.pageId, blockId: this.blockId }
			}).done(function (data) {
				responseDeferred.resolve({ editorContent: data });
				self.block.hide();
				self.getContainer().show();
				
			}).fail(function () {
				responseDeferred.reject("Error fetching block editor content");
			});
			
			return responseDeferred;
		},

		getContainer: function () {
			this.container = this.container || $("<div>")
				.addClass("brikit-live-editor")
				.append($("<form>"))
				.css({
					border: this.block.css("border"),
					borderRadius: this.block.css("border-radius"),
					boxShadow: this.block.css("box-shadow"),
					margin: this.block.css("margin"),
					width: this.block.outerWidth(),
					minHeight: this.block.outerHeight()
				});
			
			return this.container;
		},
		
		getForm: function () {
			return this.getContainer().find("form");
		},
		
		save: function (e) {
			e.preventDefault();
			var self = this;
			
			var editorContent = AJS.Rte.Content.getHtml();
			Confluence.Editor.UI.toggleSavebarBusy(false);

			$.ajax({
				url: ThemePress.contextPath + "/plugins/brikit/pages/saveblockcontent.action",
				data: { pageId: ThemePress.pageId, blockId: this.blockId, editorContent: editorContent }
			}).done(function (data) {
				self.deactivate(function () {
					var $newBlock = $($.parseXML(data)).find(".brikit-content-block").first();
					self.block.empty().append($newBlock.html());
					self.addEditControls();
				});
			}).fail(function () {
				alert("Error fetching block editor content");
			});
		}

	});
	
	
})(jQuery);

ThemePress.toFinalize(function ($) {
	if (ThemePress.isHistoricalVersion()) return false;

	$("body:not(.no-layer-added) .brikit-content-layers .brikit-content-block.live-edit").each(function () { new BrikitLiveEditor(this); });	
});