/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.xwork.FileUploadUtils;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.LoadDesignerAction;
import com.brikit.themepress.settings.ThemePlugin;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class SelectImageAction
extends LoadDesignerAction {
    protected String imageName;
    protected BufferedImage bufferedImage;
    protected List<String> themeImages;

    public String upload() {
        if (!(ServletActionContext.getRequest() instanceof MultiPartRequestWrapper)) {
            return "input";
        }
        return this.handleUploadedFile((MultiPartRequestWrapper)ServletActionContext.getRequest());
    }

    private String handleUploadedFile(MultiPartRequestWrapper multiWrapper) {
        FileUploadUtils.UploadedFile uploadedFile;
        try {
            uploadedFile = this.getUploadedFile(multiWrapper);
        }
        catch (FileUploadUtils.FileUploadException e) {
            String[] errors = e.getErrors();
            for (int j = 0; j < errors.length; ++j) {
                this.addActionError(GeneralUtil.getUploadFileTooLargeMessage((String)e.getErrors()[j]));
            }
            return "error";
        }
        if (uploadedFile == null) {
            this.addActionError(this.getText("com.brikit.file.upload.failed", uploadedFile.getFileName()));
            return "error";
        }
        try {
            ImageIO.read(uploadedFile.getFile());
        }
        catch (IllegalArgumentException e) {
            this.addActionError(this.getText("com.brikit.image.read.failed"));
            BrikitFile.removeFile(uploadedFile.getFile());
            return "error";
        }
        catch (IOException e) {
            this.addActionError(this.getText("com.brikit.file.open.failed"));
            return "error";
        }
        File destination = ThemePlugin.getImageLocation(this.getThemeNameFromProperties(), uploadedFile.getFileName());
        try {
            BrikitFile.copy(uploadedFile.getFile(), destination);
        }
        catch (IOException e) {
            this.addActionError(this.getText("com.brikit.file.read.failed"));
            return "error";
        }
        return "success";
    }

    private FileUploadUtils.UploadedFile getUploadedFile(MultiPartRequestWrapper multiWrapper) throws FileUploadUtils.FileUploadException {
        FileUploadUtils.UploadedFile[] uploadedFiles = FileUploadUtils.handleFileUpload((MultiPartRequestWrapper)multiWrapper, (boolean)true);
        FileUploadUtils.UploadedFile uploadedFile = null;
        if (uploadedFiles.length > 0) {
            uploadedFile = uploadedFiles[0];
        }
        return uploadedFile;
    }

    public String remove() {
        File image = ThemePlugin.getImageLocation(this.getThemeNameFromProperties(), this.getImageName());
        if (image != null && image.exists()) {
            image.delete();
        }
        return "success";
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public boolean hasImageName() {
        return BrikitString.isSet(this.getImageName());
    }

    public List<String> getThemeImages() {
        if (this.themeImages == null) {
            this.themeImages = ThemePlugin.getImageNames(this.getThemeNameFromProperties());
        }
        return this.themeImages;
    }
}

