/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitFile;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceExporter;
import java.io.File;
import java.util.Date;

public class ExportSpaceAction
extends ThemePressActionSupport {
    protected String downloadPath;
    boolean includePermissions;

    @Override
    public String execute() throws Exception {
        SpaceExporter exporter = new SpaceExporter(null, this.getSpace(), this.shouldIncludePermissions(), this.getExportSpaceName());
        exporter.exportSpace();
        File zipFile = exporter.getZipFile();
        this.setDownloadPath(BrikitFile.prepareDownloadPath(zipFile.getPath()) + "?contentType=application/zip");
        BrikitFile.allowUserToDownload(zipFile);
        return "success";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    protected String getExportSpaceName() {
        return this.getSpaceKey() + "-space-export-" + BrikitDate.formatDateTime(new Date(), Confluence.getUserTimeZone(), "yyyyMMdd-HHmmss", true);
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public void setIncludePermissions(boolean includePermissions) {
        this.includePermissions = includePermissions;
    }

    public boolean shouldIncludePermissions() {
        return this.includePermissions;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

