/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.model.SpaceWrapper;
import java.util.Calendar;

public class CreateMobileVersionAction
extends ThemePressActionSupport {
    protected AbstractPage newPage;

    @Override
    public String execute() throws Exception {
        String mobileTitle = PageWrapper.get(this.getPage()).getMobilePhonePageTitle();
        String storageFormat = Confluence.getBodyAsString((ContentEntityObject)this.getPage());
        SpaceWrapper spaceWrapper = SpaceWrapper.get(this.getSpaceKey());
        this.newPage = Confluence.isBlog(this.getPage()) ? Confluence.createBlogPost(this.getSpace(), mobileTitle, storageFormat, Calendar.getInstance()) : Confluence.createPage(this.getSpace(), mobileTitle, storageFormat, false, spaceWrapper.getOrCreateMobilePageRoot());
        Confluence.copyAttachments(this.getPage(), this.newPage);
        return "success";
    }

    public AbstractPage getNewPage() {
        return this.newPage;
    }

    public void setNewPage(AbstractPage newPage) {
        this.newPage = newPage;
    }

    public void validate() {
        super.validate();
        if (PageWrapper.get(this.getPage()) == null) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
        if (!Confluence.canCreate(this.getSpaceKey())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
        if (PageWrapper.get(this.getPage()).getMobilePhoneVersion() != null) {
            this.addActionError(this.getText("brikit.config.page.already.exists"));
        }
    }
}

