(function ($) { 
	// Alias to Brikit for backward-compatibility
	Brikit = ThemePress;
	
	ThemePress.extend({

		parentPageId: AJS.Meta.get("parent-page-id"),
		fullPageUrl: AJS.Meta.get("full-page-url"),
		pageUrl: AJS.Meta.get("page-url"),
		allowHeaderFor: AJS.Meta.get("allow-header"),
		showHeaderByDefault: AJS.Meta.get("show-header-by-default"),
		
		isDemoSpace: ThemePress.spaceKey == "themepressdemo",
		
	    colors:     	{},
	    reverseColors: 	{}

	});
	
	ThemePress.extend({
		
		architectPageName: function () {
			return ThemePress.meta("brikit-architect-page");
		},
		
		clickCanvas: function () {
			$(".brikit-canvas").click();
		},
        
		// Return the currently displayed theme name
		currentTheme: function () {
			return ThemePress.meta("theme-press-theme-name");
		},

		isArchitectPage: function () {
			return ThemePress.meta("brikit-architect-page");
		},
        
		isDeveloperMode: function () {
			return ThemePress.meta("brikit-developer-mode") == "true";
		},
		
		isHistoricalVersion: function () {
			return ThemePress.meta("historical-version") == "true";
		},
		
		isUsingDefaultTheme: function () {
			return ThemePress.meta("using-default-theme") == "true";
		},
		
		namedColors: function () {
			return ["primaryColor", "secondaryColor", "tertiaryColor", "lightColor", "mediumColor", "darkColor", "lightGrayColor", "mediumGrayColor", "darkGrayColor", "whiteColor", "transparent"];
		},
		
		// Return the current space categories
		spaceCategories: function () {
			return ThemePress.meta("space-categories");
		},

		// Return the installed Theme Press product version
		themePressVersion: function () {
			return ThemePress.meta("theme-press-version");
		},

		// Easter egg to zap changes to the theme
		zapDemoThemeChanges: function () {
			$.post(ThemePress.contextPath + "/plugins/brikit/theme/copy.action", 
				{themeName: "template", newThemeName: "demo", force: true}, 
				function () { location.reload(true); }
			);
		}
		
	});

	ThemePress.toInit( function ($) {
		// Easter egg to reset the theme
		// AJS.whenIType("zzzz").execute(ThemePress.zapDemoThemeChanges);
	});


})(jQuery);
