(function ($) { 

	ThemePress.SimpleMenu = {
		
		// Allow the header for logged in users only, unless explicitly set by the theme for anonymous users
		enableHeader: function () {
			if (themePressMobile) return false;
			return !ThemePress.anonymousUser() || ThemePress.allowHeaderFor == "anonymous";
		},
	
		// Return the button that appears in the header when the Confluence header and toolbar are hidden
		simpleMenuToggleButton: function () {
			return $("#brikit-simple-toolbar-toggle");
		}
	
	};
	
})(jQuery);

ThemePress.toFinalize( function ($) {	
	
	// If mobile, don't use the simple toolbar
	if (themePressMobile) {
		ThemePress.SimpleMenu.simpleMenuToggleButton().remove();
		return;
	}

	// Move the simple toolbar toggler
	$("#move-simple-toolbar").empty().append(ThemePress.SimpleMenu.simpleMenuToggleButton());

	// Make the items that click other elements mirror those elements
	$("#brikit-simple-toolbar .simple-menu-click-element").each(function () {
		var $link = $(this);
		var href = $link.attr("href");
		var $target = $(href);
		if (!$link.hasClass("keep-link")) $link.html($target.clone().html());
		$link.attr("title", $target.attr("title")).click(function (event) {
			event.preventDefault();
			if ($link.hasClass("needs-header") && !ThemePress.Structure.isHeaderShowing()) ThemePress.Structure.toggleHeader();
			$target.click();
		});
	});

	// Make the items that click other elements mirror those elements
	$("#brikit-simple-toolbar .simple-menu-copy-target").each(function () {
		var $link = $(this);
		var href = $link.attr("href");
		var $target = $(href);
		$link.attr("href", $target.attr("href"));
	});

});
