/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.brikit.core.actions.BrikitActionSupport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.Email;
import com.brikit.core.util.BrikitString;

public class SendEmailAction
extends BrikitActionSupport {
    protected String toEmailAddress;
    protected String emailCc;
    protected String emailBcc;
    protected String emailSubject;
    protected String emailBody;

    @Override
    public String execute() {
        Email email = new Email();
        email.setTo(this.getToEmailAddress());
        email.setFrom(Confluence.getConfluenceUser().getEmail());
        email.setSubject(this.getEmailSubject());
        email.setBody(this.getEmailBody());
        if (BrikitString.isSet(this.getEmailCc())) {
            email.setCc(this.getEmailCc());
        }
        if (BrikitString.isSet(this.getEmailBcc())) {
            email.setBcc(this.getEmailBcc());
        }
        try {
            email.send();
        }
        catch (Exception ex) {
            return this.setJSONError("Unable to send email: " + ex.getMessage());
        }
        return this.jsonSuccess("Email sent to: " + this.getToEmailAddress());
    }

    public String getEmailBcc() {
        return this.emailBcc;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailCc() {
        return this.emailCc;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getToEmailAddress() {
        return this.toEmailAddress;
    }

    public void setEmailBcc(String emailBcc) {
        this.emailBcc = emailBcc;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody;
    }

    public void setEmailCc(String emailCc) {
        this.emailCc = emailCc;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public void setToEmailAddress(String toEmailAddress) {
        this.toEmailAddress = toEmailAddress;
    }

    public void validate() {
        super.validate();
        if (Confluence.isAnonymousUser()) {
            this.addActionError(this.getText("config.insufficient.permissions"));
        }
    }
}

