(function ($) {

	RichLinkCarousel = function (carousel) {
		this.carousel = $(carousel);
		this.debug = false;
		this.autoscrollDelay = parseInt(this.carousel.data("autoscroll"));
		this.initialize();
	};
	
	var prototype = RichLinkCarousel.prototype;
	
	prototype.autoscroll = function () {
		clearTimeout(this.autoscrollTimeout);
		var next = this.currentThumbnail().next();
		if (!next.length) next = this.thumbnails.first();
		this.currentThumbnail(next);
	};
	
	prototype.autoscrollPause = function () {
		clearTimeout(this.autoscrollTimeout);
		this.autoscrollTimeout = "stop";
	};

	prototype.autoscrollResume = function () {
		this.autoscrollTimeout = 0;
		this.autoscrollStart();
	};
	
	prototype.autoscrollStart = function () {
		if (ThemePress.Browser.mobile || !this.autoscrollDelay || this.autoscrollTimeout == "stop") return;
		
		this.autoscrollTimeout = setTimeout(this.autoscroll.bind(this), this.autoscrollDelay);
	};

	prototype.carouselIndex = function () {
		return this.carousel.get(0).style.getPropertyValue("--index") * 1.0;
	};
	
	prototype.clientX = function (event) {
		var clientX = event.clientX 
			? event.clientX
			: (event.originalEvent.changedTouches ? event.originalEvent.changedTouches[0].clientX : 0);
		if (this.debug) console.log({clientX: clientX});
		return clientX;
	};
	
	prototype.currentRichLink = function () {
		var index = this.thumbnails.index(this.currentThumbnail());
		return $(this.richLinks.get(index));
	};
		
	prototype.currentThumbnail = function (thumbnail) {
		var $current = this.navigator.find(".rich-link-wrapper.current");

		if (typeof(thumbnail) == "undefined") return $current;
		
		this.scrollTo(thumbnail);
	};
	
	prototype.debugDrag = function (event) {
		if (this.debug) console.log({mouseDown: this.mouseDown, locked: this.locked, startX: this.startX, startIndex: this.startIndex, latestX: this.latestX});
	};
	
	prototype.initialize = function () {
		var self = this;
		
		this.lastScrollLeft = 0;
		this.didScroll = false;
		
		this.container = this.carousel.closest(".rich-link-carousel-container");
		this.navigator = this.container.find(".rich-link-carousel-navigator");

		this.richLinks = $(".rich-link-wrapper", this.carousel);
		this.carousel.empty().append(this.richLinks);
		
		if (this.richLinks.length < 2) return;
		
		this.thumbnails = this.richLinks.clone();
		if (ThemePress.Browser.mobile) this.thumbnails.each(function (i, e) { $(e).empty(); });
		this.navigator.append(this.thumbnails);
		
		this.currentThumbnail(this.thumbnails.first());
		
		var self = this;
		if (ThemePress.Browser.mobile) {
			// Block normal rich link clicks, we'll handle as part of the drag detection's mouseup/touchend event
			this.richLinks.find(".rich-link").click(function (e) { e.preventDefault(); });
			
			this.container
				.on("touchstart mousedown", this.lockForSwipe.bind(this))
				.on("touchmove mousemove", this.moveForSwipe.bind(this))
				.on("touchend mouseup", this.snapForSwipe.bind(this));
				
			$("#page").on("mouseleave mouseenter", this.swipeOffWindow.bind(this));
		}
		else {
			this.navigator.on("click", ".rich-link-wrapper", function (e) { e.preventDefault(); self.navigateTo(this); });
			this.container
				.on("mouseenter", this.autoscrollPause.bind(this))
				.on("mouseleave", this.autoscrollResume.bind(this));
		}
		
		this.autoscrollStart();
	};
	
	prototype.isMouseEvent = function (event) {
		return event.type.indexOf("mouse") == 0;
	};
	
	prototype.lockForSwipe = function (event) {
		this.mouseDown = this.isMouseEvent(event);
		this.locked = !this.mouseDown;
		this.startX = this.clientX(event);
		this.startIndex = this.carouselIndex();
		this.debugDrag(event);
	};

	prototype.moveCarousel = function (amount, intermediate) {
		var lowerBound = intermediate ? -0.3 : 0;
		var upperBound = this.thumbnails.length - 1;
		if (intermediate) {
			upperBound += 0.3;
			amount += this.startIndex;
		}
		 
		if (!intermediate) this.carousel.addClass("snapping");

		var next = Math.min(upperBound, Math.max(lowerBound, amount));
		// if (Math.abs(this.carouselIndex() - next) < 0.02) return;
		this.carousel.get(0).style.setProperty("--index", next);
		
		if (intermediate) return;
		this.thumbnails.removeClass("current");
		$(this.thumbnails.get(next)).addClass("current");
		this.debugDrag(event);
		
		// Wait for the scroll animation (transition time is 0.3 seconds) before resuming autoscroll
		this.autoscrollTimeout = setTimeout(this.autoscrollStart.bind(this), 300);
	};

	prototype.moveForSwipe = function (event) {
		if (this.mouseDown && this.isMouseEvent(event)) this.locked = true;
		if (!this.locked) return;
		
		$("body").addClass("rich-link-carousel-scrolling");
		this.carousel.removeClass("snapping");

		var newX = this.clientX(event);
		// if (Math.abs(newX - this.latestX) < 20) return;
		this.latestX = newX;
		
		var amount = this.startX - this.latestX;
		// if (Math.abs(amount) > 20) amount *= 2.0;
		this.moveCarousel(amount / this.container.width(), true);
		this.debugDrag(event);
	};
	
	prototype.navigateTo = function (thumbnail) {
		this.currentThumbnail(thumbnail);
	};
	
	prototype.scrollTo = function (thumbnail) {
		var index = $(thumbnail).prevAll().length;
		this.moveCarousel(index);
	};
	
	prototype.snapForSwipe = function (event) {
		// If not locked, then treat as normal click
		if (!this.locked && this.mouseDown) {
			var url = $(event.target).closest(".rich-link").attr("href");
			if (url) location.href = url;
			return;
		}
		
		this.mouseDown = false;
		
		var index = Math.round(this.carouselIndex());
		this.moveCarousel(index);
		$("body").removeClass("rich-link-carousel-scrolling");
		this.locked = false;
	};
	
	prototype.swipeOffWindow = function (event) {
		if (this.locked) this.snapForSwipe(event);
	};
	
})(jQuery);

(function ($) {
	
	ThemePress.toFinalize(function ($) {
		$(".rich-link-carousel").each(function () { new RichLinkCarousel(this); });
	});

})(jQuery);