/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.themepress.lesson.model.LessonPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LessonPlanMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/lesson-plan.vm";
    public static final String LESSON_KEY_PARAM = "lesson-keys";
    public static final String AUTO_START_PARAM = "auto-start";
    public static final String NEXT_PAGE_PARAM = "next-page";
    public static final String PREVIOUS_PAGE_PARAM = "previous-page";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        List<String> lessonNames = macroContext.listValue(LESSON_KEY_PARAM);
        ArrayList<LessonPlan> lessonPlans = new ArrayList<LessonPlan>();
        for (String lessonName : lessonNames) {
            LessonPlan lessonPlan = new LessonPlan(lessonName);
            if (lessonPlan == null) continue;
            lessonPlans.add(lessonPlan);
        }
        macroContext.velocityContextAdd("lessonPlans", lessonPlans);
        macroContext.velocityContextAdd("previousPage", macroContext.pageFromValue(PREVIOUS_PAGE_PARAM, null));
        macroContext.velocityContextAdd("nextPage", macroContext.pageFromValue(NEXT_PAGE_PARAM, null));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

