/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.BrikitZipFile;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.activation.FileDataSource;
import org.apache.commons.io.IOUtils;

public class SpaceExporter {
    public static final String ZIP_FILE_EXT = ".zip";
    public static final String JSON_FILE_EXT = ".json";
    public static final String XML_FILE_EXT = ".xml";
    public static final String SPACE_JSON_FILE = "space.json";
    public static final String ATTACHMENTS_DIR = "attachments";
    public static final String SPACE_KEY_KEY = "spaceKey";
    public static final String SPACE_NAME_KEY = "spaceName";
    public static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    public static final String PAGE_ID_KEY = "pageId";
    public static final String PARENT_PAGE_TITLE_KEY = "parentPageTitle";
    public static final String POST_DATE_KEY = "postDate";
    public static final String TYPE_KEY = "type";
    public static final String TITLE_KEY = "title";
    public static final String LABELS_KEY = "labels";
    public static final String COMMENT_KEY = "comment";
    public static final String METADATA_KEY = "metadata";
    public static final String RESTRICTIONS_KEY = "restrictions";
    public static final String VIEW_USERS_KEY = "viewUsers";
    public static final String EDIT_USERS_KEY = "editUsers";
    public static final String VIEW_GROUPS_KEY = "viewGroups";
    public static final String EDIT_GROUPS_KEY = "editGroups";
    protected String exportName;
    protected File zipFile;
    protected File exportFolder;
    protected File spaceDetailsFile;
    protected boolean includePermissions;
    protected Space space;

    public SpaceExporter(File zipFile, Space existingSpace, boolean includePermissions, String exportName) {
        this.space = existingSpace;
        this.includePermissions = includePermissions;
        this.exportName = exportName;
        this.unpackZipFile(zipFile);
    }

    protected void createPage(File pageDir, boolean overwriteExisting) throws Exception {
        Page abstractPage;
        Page homePage = Confluence.getSpaceHomePage(this.getSpace());
        File pageMeta = new File(pageDir, pageDir.getName() + JSON_FILE_EXT);
        File xmlFile = new File(pageDir, pageDir.getName() + XML_FILE_EXT);
        if (!pageMeta.exists() || !xmlFile.exists()) {
            BrikitLog.logWarning("Unable to find metadata or content for page: " + pageDir.getName() + ". Ignoring page.");
            return;
        }
        JSONObject pageJSON = new JSONObject(BrikitFile.readFileUTF8(pageMeta));
        String title = pageJSON.getString(TITLE_KEY);
        String type = pageJSON.has(TYPE_KEY) ? pageJSON.getString(TYPE_KEY) : "page";
        boolean isPage = "page".equals(type);
        Date postDate = pageJSON.has(POST_DATE_KEY) ? BrikitDate.parseDate("yyyy-MM-dd", pageJSON.getString(POST_DATE_KEY), Confluence.getSystemTimeZone()) : new Date();
        String parentPageTitle = pageJSON.has(PARENT_PAGE_TITLE_KEY) ? pageJSON.getString(PARENT_PAGE_TITLE_KEY) : null;
        Object object = abstractPage = isPage ? Confluence.getPage(this.getSpace(), title) : Confluence.getBlogPost(this.getSpace().getKey(), title, postDate);
        if (!overwriteExisting && abstractPage != null) {
            return;
        }
        String storageFormat = BrikitFile.readFileUTF8(xmlFile);
        if (abstractPage == null) {
            Calendar createDate = BrikitDate.toCalendar(postDate);
            if (isPage) {
                Page parentPage = BrikitString.isSet(parentPageTitle) ? Confluence.getPage(this.getSpace(), parentPageTitle) : null;
                abstractPage = Confluence.createPage(this.getSpace(), title, storageFormat, false, parentPage, createDate);
            } else {
                abstractPage = Confluence.createBlogPost(this.getSpace(), title, storageFormat, createDate, Confluence.getSystemTimeNow());
            }
        } else {
            Confluence.savePage((AbstractPage)abstractPage, storageFormat, "Imported from space export", false, false);
        }
        String labelString = pageJSON.getString(LABELS_KEY);
        Confluence.syncLabels((AbstractPage)abstractPage, labelString);
        if (pageJSON.has(METADATA_KEY)) {
            Confluence.applyPageMetadata(pageJSON.getJSONArray(METADATA_KEY), (AbstractPage)abstractPage);
        }
        if (this.shouldIncludePermissions()) {
            JSONObject restrictionsJSON = pageJSON.getJSONObject(RESTRICTIONS_KEY);
            String viewUsers = restrictionsJSON.has(VIEW_USERS_KEY) ? restrictionsJSON.getString(VIEW_USERS_KEY) : "";
            String editUsers = restrictionsJSON.has(EDIT_USERS_KEY) ? restrictionsJSON.getString(EDIT_USERS_KEY) : "";
            String viewGroups = restrictionsJSON.has(VIEW_GROUPS_KEY) ? restrictionsJSON.getString(VIEW_GROUPS_KEY) : "";
            String editGroups = restrictionsJSON.has(EDIT_GROUPS_KEY) ? restrictionsJSON.getString(EDIT_GROUPS_KEY) : "";
            Confluence.syncViewPermissionsUsers((AbstractPage)abstractPage, BrikitString.splitCommaSeparated(viewUsers));
            Confluence.syncEditPermissionsUsers((AbstractPage)abstractPage, BrikitString.splitCommaSeparated(editUsers));
            Confluence.syncViewPermissionsGroups((AbstractPage)abstractPage, BrikitString.splitCommaSeparated(viewGroups));
            Confluence.syncEditPermissionsGroups((AbstractPage)abstractPage, BrikitString.splitCommaSeparated(editGroups));
        }
        this.handleAttachments(pageDir, (AbstractPage)abstractPage);
    }

    protected void createOrUpdateSpace() throws Exception {
        JSONObject spaceJSON = new JSONObject(BrikitFile.readFileUTF8(this.getSpaceDetailsFile()));
        String spaceKey = spaceJSON.getString(SPACE_KEY_KEY);
        this.space = Confluence.getSpace(spaceKey);
        if (this.space != null) {
            BrikitLog.log("Space importer called to create or update space, which already exists: " + spaceKey);
        }
        String spaceName = spaceJSON.getString(SPACE_NAME_KEY);
        String spaceDescription = spaceJSON.getString(SPACE_DESCRIPTION_KEY);
        if (this.space == null) {
            this.space = Confluence.createSpace(spaceKey, spaceName, spaceDescription, false);
        }
        String labelString = spaceJSON.getString(LABELS_KEY);
        Confluence.addSpaceLabels(BrikitString.splitCommaSeparated(labelString), this.space);
        if (spaceJSON.has(METADATA_KEY)) {
            Confluence.applySpaceMetadata(spaceJSON.getJSONArray(METADATA_KEY), this.space);
        }
    }

    public void exportSpace() throws Exception {
        this.initializeExport();
        this.exportSpaceDetails(this.getSpace());
        for (Page page : Confluence.getPermittedChildren(this.getSpace())) {
            this.exportPage((AbstractPage)page, true, null);
        }
        for (BlogPost blogpost : Confluence.getAllBlogPosts(this.getSpace())) {
            this.exportPage((AbstractPage)blogpost, false, null);
        }
        this.finalizeExport();
    }

    protected void exportPage(AbstractPage abstractPage, boolean includeChildren, File pageDir) throws IOException {
        if (pageDir == null) {
            pageDir = new File(this.getExportFolder(), abstractPage.getIdAsString());
        }
        BrikitFile.ensurePathExists(pageDir);
        JSONObject json = this.pageDetails(abstractPage);
        File jsonFile = new File(pageDir, abstractPage.getIdAsString() + JSON_FILE_EXT);
        BrikitFile.writeFileUTF8(json.toString(), jsonFile);
        this.writeStorageFormat(abstractPage, pageDir);
        this.writeAttachments(abstractPage, pageDir);
        if (includeChildren && Confluence.isPage(abstractPage)) {
            for (Page child : Confluence.getPermittedChildren((Page)abstractPage)) {
                this.exportPage((AbstractPage)child, includeChildren, new File(pageDir, child.getIdAsString()));
            }
        }
    }

    public void exportPages(List<String> titles) throws Exception {
        this.initializeExport();
        for (String title : titles) {
            Page page = Confluence.getPage(this.getSpace(), title);
            this.exportPage((AbstractPage)page, false, null);
        }
        this.finalizeExport();
    }

    protected void exportSpaceDetails(Space space) throws IOException {
        JSONObject json = this.spaceDetails(space);
        File jsonFile = new File(this.getExportFolder(), SPACE_JSON_FILE);
        BrikitFile.writeFileUTF8(json.toString(), jsonFile);
    }

    protected void finalizeExport() throws Exception {
        BrikitZipFile.createZipFile(this.getExportFolder(), this.getZipFile());
        BrikitFile.removeFile(this.getExportFolder());
    }

    protected JSONObject generateAttachmentDetails(Attachment attachment) {
        String comment = Confluence.getComment(attachment);
        String labels = Confluence.getLabelString(attachment);
        if (!TextUtils.stringSet((String)comment) && !TextUtils.stringSet((String)labels)) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(COMMENT_KEY, (Object)comment);
        json.put(LABELS_KEY, (Object)labels);
        return json;
    }

    protected File getExportFolder() {
        if (this.exportFolder == null) {
            this.exportFolder = BrikitFile.getBrikitFile(this.getExportName());
        }
        return this.exportFolder;
    }

    public String getExportName() {
        return this.exportName;
    }

    public Space getSpace() {
        return this.space;
    }

    protected File getSpaceDetailsFile() {
        if (this.spaceDetailsFile == null) {
            this.spaceDetailsFile = new File(this.getExportFolder(), SPACE_JSON_FILE);
        }
        return this.spaceDetailsFile;
    }

    public File getZipFile() {
        if (this.zipFile == null) {
            this.zipFile = BrikitFile.getConfluenceTempDirectoryPath(this.getExportName() + ZIP_FILE_EXT);
        }
        return this.zipFile;
    }

    protected void handleAttachmentMeta(File attachmentsDir, File attachFile, Attachment attachment) throws Exception {
        String comment;
        File attachmentMeta = new File(attachmentsDir, attachFile.getName() + JSON_FILE_EXT);
        if (!attachmentMeta.exists()) {
            return;
        }
        JSONObject attachmentJSON = new JSONObject(BrikitFile.readFileUTF8(attachmentMeta));
        String labelsString = attachmentJSON.getString(LABELS_KEY);
        if (BrikitString.isSet(labelsString)) {
            Confluence.syncLabels(attachment, labelsString);
        }
        if (BrikitString.isSet(comment = attachmentJSON.getString(COMMENT_KEY))) {
            Confluence.setComment(attachment, comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAttachments(File pageDir, AbstractPage newPage) throws Exception {
        File attachmentsDir = new File(pageDir, ATTACHMENTS_DIR);
        if (attachmentsDir.exists()) {
            for (File attachFile : attachmentsDir.listFiles()) {
                if (attachFile.getName().endsWith(JSON_FILE_EXT)) continue;
                FileDataSource ds = new FileDataSource(attachFile.getAbsolutePath());
                Attachment attachment = Confluence.getAttachment(newPage, attachFile.getName());
                Attachment previousVersion = null;
                if (attachment == null) {
                    attachment = new Attachment(attachFile.getName(), ds.getContentType(), attachFile.length(), null);
                } else {
                    previousVersion = (Attachment)attachment.clone();
                }
                newPage.addAttachment(attachment);
                InputStream inputStream = ds.getInputStream();
                try {
                    Confluence.getAttachmentManager().saveAttachment(attachment, previousVersion, inputStream);
                }
                catch (IOException iox) {
                    BrikitLog.logError("May have failed to close attachment input stream: " + iox.getMessage());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                this.handleAttachmentMeta(attachmentsDir, attachFile, attachment);
            }
        }
    }

    public void importSpace(boolean overwriteExisting) throws Exception {
        if (this.getSpaceDetailsFile().exists()) {
            this.createOrUpdateSpace();
        }
        this.importPagesInDirectory(this.getExportFolder(), overwriteExisting);
    }

    protected void importPagesInDirectory(File directory, boolean overwriteExisting) throws Exception {
        for (File pageDir : directory.listFiles()) {
            if (!pageDir.isDirectory() || ATTACHMENTS_DIR.equals(pageDir.getName())) continue;
            this.createPage(pageDir, overwriteExisting);
            this.importPagesInDirectory(pageDir, overwriteExisting);
        }
    }

    protected void initializeExport() throws IOException {
        BrikitFile.removeFile(this.getZipFile());
        BrikitFile.removeFile(this.getExportFolder());
        BrikitFile.ensurePathExists(this.getExportFolder());
    }

    protected JSONObject pageDetails(AbstractPage abstractPage) {
        Page parentPage;
        JSONObject json = new JSONObject();
        json.put(PAGE_ID_KEY, abstractPage.getId());
        if (Confluence.isPage(abstractPage) && (parentPage = Confluence.getParent((Page)abstractPage)) != null) {
            json.put(PARENT_PAGE_TITLE_KEY, (Object)Confluence.getTitle((AbstractPage)parentPage));
        }
        json.put(TYPE_KEY, (Object)abstractPage.getType());
        json.put(POST_DATE_KEY, (Object)BrikitDate.formatDateTime(abstractPage.getCreationDate(), Confluence.getSystemTimeZone(), "yyyy-MM-dd", true));
        json.put(TITLE_KEY, (Object)abstractPage.getTitle());
        json.put(LABELS_KEY, (Object)Confluence.getLabelString(abstractPage));
        json.put(METADATA_KEY, (Object)Confluence.getPageMetadata(abstractPage, Arrays.asList("com.brikit.*")));
        if (this.shouldIncludePermissions()) {
            JSONObject restrictions = new JSONObject();
            restrictions.put(VIEW_USERS_KEY, (Object)Confluence.getViewPermissionsUserString(abstractPage));
            restrictions.put(EDIT_USERS_KEY, (Object)Confluence.getEditPermissionsUserString(abstractPage));
            restrictions.put(VIEW_GROUPS_KEY, (Object)Confluence.getViewPermissionsGroupString(abstractPage));
            restrictions.put(EDIT_GROUPS_KEY, (Object)Confluence.getEditPermissionsGroupString(abstractPage));
            json.put(RESTRICTIONS_KEY, (Object)restrictions);
        }
        return json;
    }

    public boolean shouldIncludePermissions() {
        return this.includePermissions;
    }

    protected JSONObject spaceDetails(Space space) {
        JSONObject json = new JSONObject();
        json.put(SPACE_KEY_KEY, (Object)space.getKey());
        json.put(SPACE_NAME_KEY, (Object)Confluence.getSpaceName(space.getKey()));
        json.put(SPACE_DESCRIPTION_KEY, (Object)Confluence.getSpaceDescription(space.getKey()));
        json.put(LABELS_KEY, (Object)Confluence.getLabelString(space));
        json.put(METADATA_KEY, (Object)Confluence.getSpaceMetadata(space, Arrays.asList("atlassian.confluence.*", "com.brikit.*")));
        return json;
    }

    protected void unpackZipFile(File zipFile) {
        BrikitFile.removeFile(this.getExportFolder());
        if (zipFile == null) {
            return;
        }
        try {
            BrikitZipFile zip = new BrikitZipFile(zipFile, this.getExportFolder());
            zip.extractAll();
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to read zip file:" + zipFile, ex);
        }
    }

    protected void writeAttachments(AbstractPage aPage, File destinationDir) throws IOException {
        File attachmentDirectory = new File(destinationDir, ATTACHMENTS_DIR);
        List<Attachment> attachments = Confluence.getAttachments(aPage);
        if (!attachments.isEmpty()) {
            BrikitFile.ensurePathExists(attachmentDirectory);
            for (Attachment attachment : Confluence.getAttachments(aPage)) {
                File outputFile = new File(attachmentDirectory, attachment.getFileName());
                InputStream inputStream = Confluence.getAttachmentManager().getAttachmentData(attachment);
                if (inputStream == null) {
                    BrikitLog.logWarning("Couldn't find attachment during export: " + attachment + " on page: " + aPage);
                    continue;
                }
                BrikitFile.writeInputStream(inputStream, outputFile);
                JSONObject json = this.generateAttachmentDetails(attachment);
                if (json == null) continue;
                File jsonFile = new File(attachmentDirectory, attachment.getFileName() + JSON_FILE_EXT);
                BrikitFile.writeFileUTF8(json.toString(), jsonFile);
            }
        }
    }

    protected void writeStorageFormat(AbstractPage aPage, File destinationDir) throws IOException {
        File outputFile = new File(destinationDir, aPage.getIdAsString() + XML_FILE_EXT);
        BrikitFile.writeFileUTF8(Confluence.getBodyAsString((ContentEntityObject)aPage), outputFile);
    }
}

