/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.AttachmentUploadRequest;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.LoadDesignerAction;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.awt.image.BufferedImage;
import java.util.List;

public class SelectAttachedImageAction
extends LoadDesignerAction {
    protected String imageName;
    protected BufferedImage bufferedImage;
    protected List<String> pageImages;

    public String getImageName() {
        return this.imageName;
    }

    public List<String> getPageImages() {
        if (this.pageImages == null) {
            this.pageImages = Confluence.getImageAttachmentNames(this.getPage());
        }
        return this.pageImages;
    }

    private String handleUploadedFile(MultiPartRequestWrapper multiWrapper) {
        AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(multiWrapper);
        for (AttachmentResource resource : uploadRequest.getResources()) {
            Confluence.getFileUploadManager().storeResource(resource, (ContentEntityObject)this.getPage());
        }
        return "success";
    }

    public boolean hasImageName() {
        return BrikitString.isSet(this.getImageName());
    }

    public String remove() {
        Attachment attachment = Confluence.getAttachment(this.getPage(), this.getImageName());
        if (attachment == null) {
            this.addActionError("Attachment " + this.getImageName() + " not found on " + this.getPage());
            return "error";
        }
        if (!Confluence.canRemove(attachment)) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
            return "error";
        }
        Confluence.removeAttachment(attachment);
        return "success";
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String upload() {
        if (!(ServletActionContext.getRequest() instanceof MultiPartRequestWrapper)) {
            return "input";
        }
        return this.handleUploadedFile((MultiPartRequestWrapper)ServletActionContext.getRequest());
    }
}

