// Global Targeted Search javascript functions & variables
(function ($) { 

	ThemePress = typeof(ThemePress) == "undefined" ? false : ThemePress;
	
	TargetedSearch.extend({
		
		addQueryParam: function () {
			// Search results page
			TargetedSearch.addQueryParams($("#query-string"), $("#search-results-body"), ".rich-link");
			
			// Targeted Search field quick results
			$(".targeted-search-field").each(function () {
				TargetedSearch.addQueryParams($(".targeted-search-field-query", this), $(".targeted-search-results-list", this), "li a");
			});
			
		},
		
		addQueryParams: function ($searchField, $results, selector) {
			var query = $searchField.val();
			if (!query || !query.length || $results.hasClass("queries-added")) return;
			
			$(selector, $results).each(function () { TargetedSearch.modifyHref(query, this); });

			$results.addClass("queries-added");
		},
		
		cqlDebugViewer: function () {
			return $(".cql-debug-viewer");
		},
		
		cqlEncoded: function (cql) {
			return cql
                .replace(/!!QUOTE!!SYMBOL!!/g, "%22")
                .replace(/\"/g, "%22")
                .replace(/\'/g, "%27")
                .replace(/</g, "%3C")
                .replace(/=/g, "%3D")
                .replace(/>/g, "%3E")
                .replace(/\s/g, "+")
                .replace(/,/g, "%2C");
		},
	
		modifyHref: function (query, link) {
			var href = $(link).attr("href");
			if (href) $(link).attr("href", TargetedSearch.addUrlParameter(href, "q", query));
		},
		
		openSearchPanelFromDefaultSearch: function (event) {
			event.preventDefault();
			var searchTerms = $("#query-string").val();
			var parameters = searchTerms ? "queryString=" + encodeURIComponent(searchTerms) : "";
			TargetedSearch.SearchPanel.openSearch(parameters);
		},
        
        replaceQuoteSymbolWithQuotes: function (string) {
            return string ? string.replace(/!!QUOTE!!SYMBOL!!/g, '"') : string;
        }
		
	});
	
	$(document).ajaxComplete(TargetedSearch.addQueryParam);
    
	// Initialize the expanders (added to avoid the initializeExpander() function in brikit-core from conflicting with other Brikit app versions)
	$.fn.initializeExpanderIE11Safe = function(callback) {
		return this.each(function() {
			var $expander = $(this);
			if ($expander.hasClass("initialized")) return;

			$expander.addClass("initialized");
			var $control = $expander.find(".brikit-expander-control");
			var $content = $expander.find(".brikit-expander-content").showIf($control.hasClass("expanded"));
			var $expanderIcon = $control.hasClass("expander-icon") ? $control : $control.find(".expander-icon");
			
			var useChevronIcons = $expanderIcon.attr("class") && $expanderIcon.attr("class").indexOf("chevron") != -1;
			var expandedIconClass = useChevronIcons ? "aui-iconfont-chevron-up" : "aui-iconfont-expanded";
			var collapsedIconClass = useChevronIcons ? "aui-iconfont-chevron-down" : "aui-iconfont-collapsed";

			var adjustVisibility = function () {
				var isExpanded = $control.hasClass("expanded");
				$expanderIcon.adjustClass(expandedIconClass, isExpanded);
				$expanderIcon.adjustClass(collapsedIconClass, !isExpanded);
                if (jQuery.browser.msie) $content.showIf(isExpanded);
                else $content.slideOpenIf(isExpanded, callback);
			}
			
			var toggle = function () {
				$control.toggleClass("expanded");
				adjustVisibility();
			}
			$control.click(toggle);
			if ($control.data("start-open")) $control.addClass("expanded");

			adjustVisibility();
        });
	};
	
})(jQuery);

TargetedSearch.toFinalize(function ($) {
	var $openSearchPanelLink = $("<a href='#' id='open-search-panel-link' class='aui-link'>").text(TargetedSearch.getText("com.brikit.targetedsearch.open.search.panel"));
	$("#search-results-header #search-form").append($openSearchPanelLink);
	$openSearchPanelLink.click(TargetedSearch.openSearchPanelFromDefaultSearch);
});
