/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAdminAction;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.SearchSettings;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ConfigureSearchFiltersAction
extends AbstractTargetedSearchAdminAction {
    protected static final String CHECKED = "on";
    protected static final SearchSettings SEARCH_SETTINGS = new SearchSettings();
    protected String itemKey;
    protected String displayString;
    protected String label;
    protected String parentLabel;
    protected String filterGroup;
    protected String promoted;
    protected List<FilterGroup> filterGroups;
    protected String queryLogging;
    protected String disableRichLinks;
    protected String replaceDefaultSearch;
    protected List<String> visibleTo;
    protected String spaceCategory;
    protected String excludeSpaceCategory;
    protected SearchManager searchManager;

    @PermittedMethods(value={HttpMethod.POST})
    public String addFilter() {
        FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(this.getFilterGroup());
        Filter filter = new Filter(filterGroup, this.getDisplayString(), this.getLabel(), this.isPromotedBoolean());
        BrikitList<String> errors = filter.validate();
        if (errors.isEmpty()) {
            filterGroup.addFilterAndSave(filter);
            return "success";
        }
        for (String errorMssg : errors) {
            this.addActionError(errorMssg);
        }
        return "error";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String addFilterGroup() {
        FilterGroup filterGroup = new FilterGroup(this.getDisplayString());
        filterGroup.setLabelPrefix(BrikitString.trimToNull((String)this.getLabel()));
        filterGroup.setParentFilter(Filter.getFilterByLabel(this.getParentLabel()));
        if (!filterGroup.hasParentFilter()) {
            filterGroup.setPromoted(this.isPromotedBoolean());
        }
        List<String> errors = filterGroup.validate();
        if (BrikitString.isSet((String)this.getParentLabel()) && !filterGroup.hasParentFilter()) {
            errors.add("Invalid parent filter specified: " + this.getParentLabel());
        }
        if (errors.isEmpty()) {
            Class<FilterGroup> clazz = FilterGroup.class;
            synchronized (FilterGroup.class) {
                if (filterGroup.hasParentFilter()) {
                    filterGroup.getParentFilter().addSubcategory(filterGroup);
                    FilterGroup.saveFilterGroups();
                } else {
                    ArrayList<FilterGroup> filterGroups = new ArrayList<FilterGroup>(FilterGroup.getFilterGroups());
                    filterGroups.add(filterGroup);
                    FilterGroup.saveFilterGroups(filterGroups);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "success";
            }
        }
        for (String errorMssg : errors) {
            this.addActionError(errorMssg);
        }
        return "error";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String addSpaceCategories() {
        if (!BrikitString.isSet((String)this.getFilterGroup())) {
            String errorMssg = MessageFormat.format(Confluence.getText((String)"com.brikit.targetedsearch.settings.unknown.server.error"), "FilterGroup is null");
            this.addActionError(errorMssg);
            return "error";
        }
        BrikitList spaceCategories = BrikitString.split((String)this.getSpaceCategory().trim());
        BrikitList excludeSpaceCategories = BrikitString.split((String)this.getExcludeSpaceCategory().trim());
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(this.getFilterGroup());
            for (String spaceLabel : spaceCategories) {
                filterGroup.addVisibleTo(spaceLabel);
            }
            for (String spaceLabel : excludeSpaceCategories) {
                filterGroup.addExcludeFrom(spaceLabel);
            }
            FilterGroup.saveFilterGroups();
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return "success";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String deleteMultipleSettings() {
        if (this.getItemKey() == null) {
            BrikitLog.log((String)"On DeleteMultipleSettings, no items specified");
            return "error";
        }
        List<String> itemList = Arrays.asList(this.getItemKey().split(","));
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            for (String item : itemList) {
                FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(item);
                Filter filter = Filter.getFilterByKey(item);
                if (filterGroup != null) {
                    filterGroup.delete();
                    continue;
                }
                if (filter == null) continue;
                filter.delete();
            }
            FilterGroup.saveFilterGroups();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return "success";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.GET})
    public String deleteSetting() {
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(this.getItemKey());
            if (filterGroup != null) {
                filterGroup.delete();
                FilterGroup.saveFilterGroups();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "success";
            }
            Filter filter = Filter.getFilterByKey(this.getItemKey());
            if (filter == null) {
                filter = Filter.getFilterByLabel(this.getLabel());
            }
            if (filter != null) {
                filter.delete();
                FilterGroup.saveFilterGroups();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "success";
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.addActionError("Selected setting not found.");
            BrikitLog.log((String)("On deleteSetting, selected setting not found by key (" + this.getItemKey() + ") or, if filter, by label (" + this.getLabel() + ")"));
            return "error";
        }
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String disableDuplicateFilterNames() {
        SearchSettings.setAllowDuplicateFilterNames(false);
        return "success";
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String editRichLinksSettings() {
        SearchSettings.setRichLinksDisabled(CHECKED.equalsIgnoreCase(this.getDisableRichLinks()));
        return "success";
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String enableDuplicateFilterNames() {
        SearchSettings.setAllowDuplicateFilterNames(true);
        return "success";
    }

    public boolean getAllowDuplicateFilterNames() {
        return SearchSettings.allowDuplicateFilterNames();
    }

    public String getDisableRichLinks() {
        return this.disableRichLinks;
    }

    public String getDisplayString() {
        return this.displayString == null ? null : this.displayString.trim();
    }

    public String getExcludeSpaceCategory() {
        return this.excludeSpaceCategory;
    }

    public String getFilterGroup() {
        return this.filterGroup;
    }

    public List<FilterGroup> getFilterGroups() {
        if (this.filterGroups == null) {
            List<FilterGroup> allFilterGroups = FilterGroup.getFilterGroups();
            Collections.sort(allFilterGroups);
            this.filterGroups = allFilterGroups;
        }
        return this.filterGroups;
    }

    public String getItemKey() {
        return this.itemKey == null ? null : this.itemKey.trim();
    }

    public String getLabel() {
        return this.label;
    }

    public String getParentLabel() {
        return this.parentLabel;
    }

    public String getPromoted() {
        return this.promoted;
    }

    public String getQueryLogging() {
        return this.queryLogging;
    }

    public String getReplaceDefaultSearch() {
        return this.replaceDefaultSearch;
    }

    public SearchSettings getSearchSettings() {
        return SEARCH_SETTINGS;
    }

    public String getSpaceCategory() {
        return this.spaceCategory;
    }

    public List<String> getVisibleTo() {
        if (this.visibleTo == null) {
            this.visibleTo = new ArrayList<String>();
        }
        return this.visibleTo;
    }

    public boolean isPromotedBoolean() {
        return BrikitBoolean.booleanValue((String)this.promoted);
    }

    @Override
    public boolean isRichLinksDisabled() {
        return SearchSettings.isRichLinksDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String removeExcludeFromSpaceCategory() {
        if (!BrikitString.isSet((String)this.getFilterGroup())) {
            BrikitLog.logError((String)"No Targeted Search FilterGroup specified on request to remove visibility selection.");
            this.addActionError("Filter group not specified.");
            return "error";
        }
        if (!BrikitString.isSet((String)this.getExcludeSpaceCategory())) {
            BrikitLog.logError((String)"No Space category specified on request to remove Filter Group visibility selection.");
            this.addActionError("Space category not specified.");
            return "error";
        }
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(this.getFilterGroup());
            if (filterGroup == null) {
                BrikitLog.logError((String)"Targeted Search FilterGroup not found on request to remove Filter Group visibility selection.");
                this.addActionError("Filter group not found.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "error";
            }
            filterGroup.removeExcludeFromSetting(this.getExcludeSpaceCategory());
            FilterGroup.saveFilterGroups();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "success";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String removeSpaceCategory() {
        if (!BrikitString.isSet((String)this.getFilterGroup())) {
            BrikitLog.logError((String)"No Targeted Search FilterGroup specified on request to remove visibility selection.");
            this.addActionError("Filter group not specified.");
            return "error";
        }
        if (!BrikitString.isSet((String)this.getSpaceCategory())) {
            BrikitLog.logError((String)"No Space category specified on request to remove Filter Group visibility selection.");
            this.addActionError("Space category not specified.");
            return "error";
        }
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(this.getFilterGroup());
            if (filterGroup == null) {
                BrikitLog.logError((String)"Targeted Search FilterGroup not found on request to remove Filter Group visibility selection.");
                this.addActionError("Filter group not found.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "error";
            }
            filterGroup.removeVisibleToSetting(this.getSpaceCategory());
            FilterGroup.saveFilterGroups();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "success";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String saveFilter() {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            Filter filter = Filter.getFilterByKey(this.getItemKey());
            if (filter == null) {
                errors.add((CallSite)((Object)("Filter " + this.getDisplayString() + " not found.")));
            } else {
                filter.setDisplayName(this.getDisplayString());
                filter.setLabelSuffix(this.getLabel());
                filter.setPromoted(this.isPromotedBoolean());
                errors = filter.validate();
            }
            if (errors.isEmpty()) {
                FilterGroup.saveFilterGroups();
                // ** MonitorExit[clazz] (shouldn't be in output)
                return "success";
            }
            FilterGroup.resetCaches();
            // ** MonitorExit[clazz] (shouldn't be in output)
            for (String string : errors) {
                this.addActionError(string);
            }
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermittedMethods(value={HttpMethod.POST})
    public String saveFilterGroup() {
        ArrayList<String> errors = new ArrayList<String>();
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByKey(this.getItemKey());
            filterGroup.setDisplayName(BrikitString.trimToString((String)this.getDisplayString()));
            filterGroup.setLabelPrefix(BrikitString.trimToNull((String)this.getLabel()));
            if (!filterGroup.hasParentFilter()) {
                filterGroup.setPromoted(this.isPromotedBoolean());
            }
            errors.addAll(filterGroup.validate());
            if (errors.isEmpty()) {
                FilterGroup.saveFilterGroups();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return "success";
            }
            FilterGroup.resetCaches();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (String errorMssg : errors) {
                this.addActionError(errorMssg);
            }
            return "error";
        }
    }

    @StrutsParameter
    public void setDisableRichLinks(String disableRichLinks) {
        this.disableRichLinks = disableRichLinks;
    }

    @StrutsParameter
    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    @StrutsParameter
    public void setExcludeSpaceCategory(String excludeSpaceCategory) {
        this.excludeSpaceCategory = excludeSpaceCategory;
    }

    @StrutsParameter
    public void setFilterGroup(String filterGroup) {
        this.filterGroup = filterGroup;
    }

    @StrutsParameter
    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    @StrutsParameter
    public void setLabel(String label) {
        this.label = label;
    }

    @StrutsParameter
    public void setParentLabel(String parentLabel) {
        this.parentLabel = parentLabel;
    }

    @StrutsParameter
    public void setPromoted(String promoted) {
        this.promoted = promoted;
    }

    @StrutsParameter
    public void setQueryLogging(String queryLogging) {
        this.queryLogging = queryLogging;
    }

    @StrutsParameter
    public void setReplaceDefaultSearch(String replaceDefaultSearch) {
        this.replaceDefaultSearch = replaceDefaultSearch;
    }

    @StrutsParameter
    public void setSpaceCategory(String spaceCategory) {
        this.spaceCategory = spaceCategory;
    }

    @StrutsParameter
    public void setVisibleTo(List<String> visibleTo) {
        this.visibleTo = visibleTo;
    }

    @Override
    public void validate() {
        if (!TargetedSearch.canEditTaxonomy()) {
            this.addActionError(Confluence.getText((String)"config.insufficient.permissions"));
        }
    }
}

