/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.extractor;

import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.TextFieldDescriptor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.model.CascadingLabel;
import com.brikit.targetedsearch.model.Filter;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="cascadingLabelExtractor")
public class CascadingLabelExtractor
implements Extractor2 {
    public static final String CASCADING_LABEL_FIELD_NAME = "cascadingLabel";
    protected static ConfluenceUser adminUser;
    protected static long adminUserTimestamp;
    protected static final StringBuilder EMPTY_STRING_BUILDER;

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        BrikitList fieldDescriptors = new BrikitList();
        if (!(searchable instanceof Page)) {
            return fieldDescriptors;
        }
        Page page = (Page)searchable;
        ConfluenceUser indexerUser = Confluence.getConfluenceUser();
        long now = new Date().getTime();
        if (now - adminUserTimestamp > 600000L) {
            adminUser = Confluence.findAnyConfluenceAdministrator();
            if (adminUser == null) {
                BrikitLog.logError((String)"Unable to find a Confluence Administrator account, so cascading labels may not be added to the Confluence search index.");
            }
            adminUserTimestamp = now;
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)adminUser);
        this.extractCascadingLabels(page, (BrikitList<FieldDescriptor>)fieldDescriptors);
        this.extractInheritedLabels(page, (BrikitList<FieldDescriptor>)fieldDescriptors);
        AuthenticatedUserThreadLocal.set((ConfluenceUser)indexerUser);
        return fieldDescriptors;
    }

    public StringBuilder extractText(Object searchable) {
        if (!(searchable instanceof Page)) {
            return EMPTY_STRING_BUILDER;
        }
        StringBuilder builder = new StringBuilder();
        BrikitList searchText = new BrikitList();
        for (Filter filter : CascadingLabel.inheritedLabelsForPage((AbstractPage)((Page)searchable))) {
            searchText.add((Object)filter.getLabel());
        }
        builder.append(searchText.join(" "));
        return builder;
    }

    protected void extractCascadingLabels(Page page, BrikitList<FieldDescriptor> fieldDescriptors) {
        BrikitList<String> cascadingLabels = CascadingLabel.cascadingLabelsForPage((AbstractPage)page);
        if (cascadingLabels == null || cascadingLabels.isEmpty()) {
            return;
        }
        BrikitLog.logDebug((String)("Indexing for: " + page + " with cascading labels: " + cascadingLabels));
        for (String label : cascadingLabels) {
            BrikitLog.logDebug((String)("Adding cascading label '" + label + "' to index for page: " + page));
            fieldDescriptors.add((Object)this.stringDescriptor(CASCADING_LABEL_FIELD_NAME, label));
        }
    }

    protected void extractInheritedLabels(Page page, BrikitList<FieldDescriptor> fieldDescriptors) {
        BrikitList<String> inheritedLabels = CascadingLabel.inheritedLabelsAsStringsForPage((AbstractPage)page);
        BrikitList labelsWithNamespace = new BrikitList();
        for (String label : inheritedLabels) {
            labelsWithNamespace.add((Object)(Namespace.GLOBAL.getPrefix() + ":" + label));
        }
        BrikitLog.logDebug((String)("Indexing for: " + page + " with inherited labels: " + inheritedLabels));
        for (String label : labelsWithNamespace) {
            fieldDescriptors.add((Object)this.stringDescriptor("label", label));
        }
        fieldDescriptors.add((Object)this.textDescriptor("labelText", new BrikitList(inheritedLabels).join(" ")));
    }

    protected StringFieldDescriptor stringDescriptor(String key, String value) {
        return new StringFieldDescriptor(key, value, FieldDescriptor.Store.YES);
    }

    protected TextFieldDescriptor textDescriptor(String key, String value) {
        return new TextFieldDescriptor(key, value, FieldDescriptor.Store.YES);
    }

    static {
        adminUserTimestamp = 0L;
        EMPTY_STRING_BUILDER = new StringBuilder(0);
    }
}

