/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAdminAction;
import com.brikit.targetedsearch.model.CQLComposer;
import com.brikit.targetedsearch.model.Folksonomy;
import com.brikit.targetedsearch.model.PagingCQLSearcher;
import java.util.Collections;
import java.util.List;

public class ReplaceLabelAction
extends AbstractTargetedSearchAdminAction {
    protected String oldLabels;
    protected String newLabels;

    public String execute() {
        this.logLabelReplacement(true);
        BrikitList<String> adjustedNewLabels = Folksonomy.adjustLabels(this.getNewLabelsList());
        BrikitList<String> adjustedOldLabels = Folksonomy.adjustLabels(this.getOldLabelsList());
        Folksonomy.addLabels(adjustedNewLabels);
        int next = 0;
        int maxResults = 100;
        while (next > -1) {
            PagingCQLSearcher searcher = new PagingCQLSearcher(this.getSpaceKey(), this.getPage());
            PageResponse<Content> pageResponse = searcher.search(this.getCql(), next, maxResults);
            if (pageResponse == null) {
                BrikitLog.logError((String)"Unable to run search: no page response content object returned.");
                return "error";
            }
            for (ContentEntityObject ceo : searcher.convertResults()) {
                if (ceo instanceof AbstractPage) {
                    AbstractPage aPage = (AbstractPage)ceo;
                    Confluence.removeLabels(adjustedOldLabels, (AbstractPage)aPage);
                    Confluence.addLabelsFromStrings(adjustedNewLabels, (AbstractPage)aPage);
                    this.logLabelReplacementOnEntity(ceo);
                    continue;
                }
                if (!(ceo instanceof Attachment)) continue;
                Confluence.removeLabels(adjustedOldLabels, (Attachment)((Attachment)ceo));
                Confluence.addLabels(adjustedNewLabels, (Attachment)((Attachment)ceo));
                this.logLabelReplacementOnEntity(ceo);
            }
            next = searcher.getNextResult();
        }
        this.logLabelReplacement(false);
        JSONObject json = new JSONObject();
        json.put("success", true);
        this.setResult(json.toString());
        return "success";
    }

    protected String getCql() {
        CQLComposer cqlComposer = new CQLComposer();
        BrikitList<String> adjustedOldLabels = Folksonomy.adjustLabels(this.getOldLabelsList());
        if (BrikitString.isSet((String)this.getSpaceKey())) {
            cqlComposer.setSpaceSearchScope(Collections.singletonList(this.getSpaceKey()));
        }
        cqlComposer.setSearchFilters((List<String>)adjustedOldLabels);
        cqlComposer.setFilterOption("all");
        BrikitList andClauses = new BrikitList();
        andClauses.add((Object)cqlComposer.labelInClauseForFilters(adjustedOldLabels, false));
        andClauses.add((Object)cqlComposer.spaceKeyClause());
        andClauses.compact();
        return andClauses.join(" and ");
    }

    public String getNewLabels() {
        return this.newLabels;
    }

    protected BrikitList<String> getNewLabelsList() {
        return BrikitString.splitCommaOrSpaceSeparated((String)this.getNewLabels());
    }

    public String getOldLabels() {
        return this.oldLabels;
    }

    protected BrikitList<String> getOldLabelsList() {
        return BrikitString.splitCommaOrSpaceSeparated((String)this.getOldLabels());
    }

    private void logLabelReplacement(boolean isStarting) {
        StringBuilder mssg = isStarting ? new StringBuilder("Begin label replacement: replace ") : new StringBuilder("Finished label replacement: replaced ");
        mssg.append(this.getOldLabels());
        mssg.append(" with: ");
        mssg.append(this.getNewLabels());
        BrikitLog.log((String)mssg.toString());
    }

    private void logLabelReplacementOnEntity(ContentEntityObject entity) {
        StringBuilder mssg = new StringBuilder("On object: ");
        mssg.append(entity.getTitle());
        mssg.append(" (url: ");
        mssg.append(entity.getUrlPath());
        mssg.append(") replacing label(s) ");
        mssg.append(this.getOldLabels());
        mssg.append(" with: ");
        mssg.append(this.getNewLabels());
        BrikitLog.log((String)mssg.toString());
    }

    public void setNewLabels(String newLabels) {
        this.newLabels = newLabels;
    }

    public void setOldLabels(String oldLabels) {
        this.oldLabels = oldLabels;
    }

    @Override
    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(Confluence.getText((String)"config.insufficient.permissions"));
        }
    }
}

