/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.targetedsearch.macros.AbstractFacetAwareMacro;
import com.brikit.targetedsearch.model.FilterGroup;
import java.util.ArrayList;
import java.util.Map;

public class InteractiveSearchMacro
extends AbstractFacetAwareMacro {
    protected static final String TEMPLATE = "targeted-search/templates/interactive-search.vm";
    protected static final String LOAD_MORE_BUTTON_TEXT_KEY = "load-more-button-text";
    protected static final String LOAD_MORE_BUTTON_TEXT = "loadMoreButtonText";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        this.validateFilterGroups(macroContext);
        this.initializeVelocityContext(macroContext);
        macroContext.velocityContextAdd("max", macroContext.integerValue("max", 15));
        if (this.getSimpleFilterList(macroContext).isEmpty()) {
            ArrayList<FilterGroup> filterGroups = new ArrayList<FilterGroup>();
            for (String filterGroupName : macroContext.commaSeparatedListValue("show-groups")) {
                FilterGroup filterGroup = FilterGroup.getFilterGroupByName(filterGroupName);
                if (filterGroup == null) {
                    filterGroup = FilterGroup.getFilterGroupByKey(filterGroupName);
                }
                if (filterGroup == null) continue;
                filterGroups.add(filterGroup);
            }
            macroContext.velocityContextAdd("filterGroups", filterGroups);
        }
        macroContext.velocityContextAdd(LOAD_MORE_BUTTON_TEXT, macroContext.stringValue(LOAD_MORE_BUTTON_TEXT_KEY));
        macroContext.velocityContextAdd("action", (Object)this);
        macroContext.velocityContextAdd("page", macroContext.getPage());
        return this.renderTemplate(TEMPLATE, macroContext);
    }
}

