/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import java.util.Collections;
import java.util.List;

public class ManageFilterLabelsAction
extends AbstractTargetedSearchAction {
    protected String key;
    protected static final String TRUE = "true";
    protected static final String ERROR_MSSG = "Filter label update could not be completed. Please contact your administrator.";

    public String renderLabelsEditor() {
        if (!BrikitString.isSet(this.getKey()) || !BrikitString.isSet(this.getPageId())) {
            this.addActionError("ManageFilterLabelsAction.renderLabelsEditor:  spaceKey and/or pageId is null.");
            return "error";
        }
        return "success";
    }

    public List<FilterGroup> getAvailableFilterGroups() {
        if (!this.isLicensed()) {
            return Collections.EMPTY_LIST;
        }
        BrikitList<FilterGroup> filterGroups = FilterGroup.getFilterGroupsForSpace(this.getKey());
        Collections.sort(filterGroups);
        return filterGroups;
    }

    public List<String> getFolksonomy() {
        if (!this.isLicensed()) {
            return Collections.EMPTY_LIST;
        }
        BrikitList<String> folksonomy = Folksonomy.getFolksonomy();
        Collections.sort(folksonomy);
        return folksonomy;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

