/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.util.actions.ContentTypesDisplayMapper;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.spring.container.ContainerManager;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.CQLComposer;
import java.util.List;

public class ComposeCQLAction
extends AbstractTargetedSearchAction {
    protected CQLComposer cqlComposer;
    protected int maxResults;
    protected boolean displayRichLinks;
    protected String result;

    @Override
    public String execute() {
        JSONObject json = new JSONObject();
        json.put("cql", (Object)this.getCqlComposer().cql());
        json.put("success", true);
        this.setResult(json.toString());
        return "success";
    }

    protected CQLComposer getCqlComposer() {
        if (this.cqlComposer == null) {
            this.cqlComposer = new CQLComposer();
        }
        return this.cqlComposer;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public String getResultHTML() {
        return this.result;
    }

    public String getResultType(SearchResult searchResult) {
        String type = searchResult.getType().toLowerCase();
        if (type.contains("attachment")) {
            return ContentTypesDisplayMapper.getIconForAttachment((String)searchResult.getType(), (String)searchResult.getDisplayTitle());
        }
        ContentTypesDisplayMapper mapper = (ContentTypesDisplayMapper)ContainerManager.getComponent((String)"contentTypesDisplayMapper");
        return mapper.getClassName(searchResult);
    }

    public boolean isDisplayRichLinks() {
        return this.displayRichLinks;
    }

    public void setAdditionalFilters(List<String> additionalFilters) {
        this.getCqlComposer().setAdditionalFilters(additionalFilters);
    }

    public void setContentTypes(List<String> contentTypes) {
        this.getCqlComposer().setContentTypes(contentTypes);
    }

    public void setContributor(String contributor) {
        BrikitList<String> contributorList = new BrikitList<String>();
        contributorList.add(contributor);
        this.setContributors(contributorList);
    }

    public void setContributors(List<String> contributors) {
        this.getCqlComposer().setContributors(new BrikitList<String>(contributors));
    }

    public void setDisplayRichLinks(boolean displayRichLinks) {
        this.displayRichLinks = displayRichLinks;
    }

    public void setExcludeFilters(List<String> excludeLabels) {
        this.getCqlComposer().setExcludeFilters(excludeLabels);
    }

    public void setFilterOption(String option) {
        this.getCqlComposer().setFilterOption(option);
    }

    public void setLastModified(String lastModified) {
        this.getCqlComposer().setLastModified(lastModified);
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setQueryString(String queryString) {
        this.getCqlComposer().setQueryString(queryString);
    }

    @Override
    public void setResult(String result) {
        this.result = result;
    }

    public void setSearchFilters(List<String> searchFilters) {
        this.getCqlComposer().setSearchFilters(BrikitList.removeBlanks(searchFilters));
    }

    public void setSearchPageTitles(boolean searchPageTitles) {
        this.getCqlComposer().setSearchPageTitles(searchPageTitles);
    }

    public void setSearchScope(List<String> searchScope) {
        this.getCqlComposer().setSearchScope(searchScope);
    }

    public void setSortBy(String sortBy) {
        this.getCqlComposer().setSortBy(sortBy);
    }

    public void setSpaceSearchScope(List<String> searchScope) {
        this.getCqlComposer().setSpaceSearchScope(searchScope);
    }

    public void setWildcard(boolean wildcard) {
        this.getCqlComposer().setWildcardSearch(wildcard);
    }
}

