/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.brikit.core.util.BrikitString;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrikitNumber {
    public static boolean coinToss() {
        return BrikitNumber.coinToss(2);
    }

    public static boolean coinToss(int sidesOnCoin) {
        return BrikitNumber.randomNumber(1, sidesOnCoin) == 1;
    }

    public static int integerValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static long longValue(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public static float parseFloat(String floatString) {
        if (!BrikitString.isSet(floatString)) {
            return 0.0f;
        }
        Matcher matcher = Pattern.compile("^(-{0,1}[0-9\\.]+)").matcher(floatString.trim());
        return matcher.find() ? Float.parseFloat(matcher.group(1)) : 0.0f;
    }

    public static int parseInteger(String intString) {
        if (!BrikitString.isSet(intString)) {
            return 0;
        }
        Matcher matcher = Pattern.compile("^(-{0,1}[0-9]+)").matcher(intString.trim());
        return matcher.find() ? Integer.parseInt(matcher.group(1)) : 0;
    }

    public static long parseLong(String longString) {
        if (!BrikitString.isSet(longString)) {
            return 0L;
        }
        Matcher matcher = Pattern.compile("^(-{0,1}[0-9]+)").matcher(longString.trim());
        return matcher.find() ? Long.parseLong(matcher.group(1)) : 0L;
    }

    public static int randomIndex(List aList) {
        return BrikitNumber.randomNumber(0, aList.size() - 1);
    }

    public static int randomNumber(int start, int stop) {
        return start + new Random().nextInt(stop - start + 1);
    }
}

