/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.search.DelegatedSearchResultRenderer;
import com.atlassian.confluence.search.lucene.queryparser.QueryUtil;
import com.atlassian.confluence.search.summary.HitHighlighter;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.brikit.core.confluence.Confluence;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.PagingCQLSearcher;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;

public class AutoloadSearchAction
extends AbstractTargetedSearchAction {
    protected String cql;
    protected String queryString;
    protected int chunkSize;
    protected int next;
    protected int totalMatches;
    protected double searchTime;
    protected boolean displayRichLinks;
    protected boolean displaySearchResults;
    protected List<ContentEntityObject> results;
    protected DelegatedSearchResultRenderer renderer;
    protected HitHighlighter highlighter;
    protected Analyzer queryAnalyzer;

    @Override
    public String execute() {
        PagingCQLSearcher searcher = new PagingCQLSearcher(this.getSpaceKey(), this.getPage());
        PageResponse<Content> pageResponse = searcher.search(this.getCql(), this.getNext(), this.getChunkSize());
        if (pageResponse == null) {
            return "error";
        }
        this.setResults(searcher.convertResults());
        this.setNext(searcher.getNextResult());
        this.setTotalMatches(searcher.totalMatches());
        this.setSearchTime((double)searcher.getSearchTime() / 1000.0);
        return "success";
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public String getCql() {
        return this.cql;
    }

    public DelegatedSearchResultRenderer getDelegatedSearchResultRenderer() {
        return this.renderer;
    }

    public int getNext() {
        return this.next;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<ContentEntityObject> getResults() {
        return this.results;
    }

    public double getSearchTime() {
        return this.searchTime;
    }

    public int getTotalMatches() {
        return this.totalMatches;
    }

    public boolean isDisplayRichLinks() {
        return this.displayRichLinks;
    }

    public boolean isDisplaySearchResults() {
        return this.displaySearchResults;
    }

    @HtmlSafe
    public String highlightSummaryForQuery(ContentEntityObject ceo) {
        String title;
        String content = Confluence.getBodyPlainText(ceo);
        if (content.startsWith(title = ceo.getDisplayTitle())) {
            content = content.substring(title.length());
        }
        return this.getHighlighter().getSummary(content);
    }

    private HitHighlighter getHighlighter() {
        if (this.highlighter == null) {
            try {
                Query query = new QueryParser(BonnieConstants.LUCENE_VERSION, "", this.getQueryAnalyzer()).parse(QueryUtil.escape((String)this.getQueryString()));
                this.highlighter = new HitHighlighter(query, this.getQueryAnalyzer());
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.highlighter;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public void setDelegatedSearchResultRenderer(DelegatedSearchResultRenderer defaultRenderer) {
        this.renderer = defaultRenderer;
    }

    public void setDisplayRichLinks(boolean displayRichLinks) {
        this.displayRichLinks = displayRichLinks;
    }

    public void setDisplaySearchResults(boolean displaySearchResults) {
        this.displaySearchResults = displaySearchResults;
    }

    public void setNext(int next) {
        this.next = next;
    }

    public void setQueryAnalyzer(Analyzer queryAnalyzer) {
        this.queryAnalyzer = queryAnalyzer;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    protected void setResults(List<ContentEntityObject> results) {
        this.results = results;
    }

    public void setSearchTime(double searchTime) {
        this.searchTime = searchTime;
    }

    public void setTotalMatches(int totalMatches) {
        this.totalMatches = totalMatches;
    }
}

