/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.comalaworkflowsservice;

import com.google.common.base.Preconditions;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class OptionalService<T1, T2, T3, T4>
implements InitializingBean,
DisposableBean {
    private final Class<T1> approvalType;
    private final Class<T2> stateType;
    private final Class<T3> taskType;
    private final Class<T4> workflowType;
    private final ServiceTracker approvalTracker;
    private final ServiceTracker stateTracker;
    private final ServiceTracker taskTracker;
    private final ServiceTracker workflowTracker;

    public OptionalService(BundleContext bundleContext, Class<T1> approvalType, Class<T2> stateType, Class<T3> taskType, Class<T4> workflowType) {
        this.approvalType = (Class)Preconditions.checkNotNull(approvalType, (Object)"approvalType");
        this.stateType = (Class)Preconditions.checkNotNull(stateType, (Object)"stateType");
        this.taskType = (Class)Preconditions.checkNotNull(taskType, (Object)"taskType");
        this.workflowType = (Class)Preconditions.checkNotNull(workflowType, (Object)"workflowType");
        this.approvalTracker = new ServiceTracker(bundleContext, approvalType.getName(), null);
        this.stateTracker = new ServiceTracker(bundleContext, stateType.getName(), null);
        this.taskTracker = new ServiceTracker(bundleContext, taskType.getName(), null);
        this.workflowTracker = new ServiceTracker(bundleContext, workflowType.getName(), null);
    }

    protected final T1 getApprovalService() {
        return this.approvalType.cast(this.approvalTracker.getService());
    }

    protected final T2 getStateService() {
        return this.stateType.cast(this.stateTracker.getService());
    }

    protected final T3 getTaskService() {
        return this.taskType.cast(this.taskTracker.getService());
    }

    protected final T4 getWorkflowService() {
        return this.workflowType.cast(this.workflowTracker.getService());
    }

    public void afterPropertiesSet() throws Exception {
        this.approvalTracker.open();
        this.stateTracker.open();
        this.taskTracker.open();
        this.workflowTracker.open();
    }

    public final void destroy() {
        this.approvalTracker.close();
        this.stateTracker.close();
        this.taskTracker.close();
        this.workflowTracker.close();
    }
}

