(function ($) { 

	TargetedSearch.MoreResultsLoader = function (loader, scrollingElement) {
		this.loader = $(loader);
		this.scrollingElement = scrollingElement;
        
        this.expansions = [
            "content.space",
			"content.metadata.labels",
			"content.container",
			"space.metadata.labels",
			"content.metadata.properties.cascadingLabels",
			"content.ancestors.metadata.properties.cascadingLabels",
			"content.metadata.properties.documentId",
			"content.metadata.properties.pageDocumentNumber",
			"content.metadata.properties.title"
		].join(",");
        
		this.debug = false;
		this.initialize();
		this.loader.data("more-results-loader", this);
	};
    
	Object.assign(TargetedSearch.MoreResultsLoader.prototype, {

		addLoadTrigger: function (loadImmediately, callback) {
			this.callback = callback;
			var $trigger = this.loadsWithButton()
				? $("<div>").addClass("load-button-holder").append($("<button>").addClass("aui-button aui-button-primary load-more-button").text(this.loadMoreButtonText)) 
				: $("<div>").addClass("load-monitor").append($("<span>").addClass("aui-icon aui-icon-wait"));
			this.append($trigger);
		
			if (loadImmediately && !this.loadsWithButton()) this.autoload();
			if (this.loadsWithScroll()) setTimeout(this.respondToBrowserChange.bind(this), 300);
		},
		
		addNoMoreResultsToLoader: function () {
			this.loader.append($("<div>").addClass("no-more-results"));
		},
		
        addTd: function ($tr, className, content, sortKey) {
            const $td = $("<td>")
                .addClass(className)
                .attr("data-sort-key", sortKey)
                .append(content);
            $tr.append($td);
        },
		
        addTh: function ($thead, className, text, sortKey) {
            const sortText = TargetedSearch.getText("com.brikit.targetedsearch.content-query.table.sort");
            const $th = $("<th>")
                .addClass(className)
                .attr("data-sort-key", sortKey)
                .addClass("no-sort")
                .append($("<span>").addClass("heading").append(TargetedSearch.getText(text)))
                // Uncomment this section to restore the clickable column headings that sort the table ascending and descending
                // .append($("<span>").addClass("sort-icon aui-icon aui-icon-small aui-iconfont-filter").text(sortText).attr("title", sortText))
                // .click(function (e) {
                //     $th.addClass("ignore");
                //     this.find("th:not(.ignore)").removeClass("sort-up sort-down").addClass("no-sort");
                //     $th.removeClass("ignore");
                //     $th.toggleClass($th.hasClass("no-sort") ? "no-sort sort-up" : "sort-up sort-down");
                //     this.sortColumn($th);
                // }.bind(this));
            $thead.append($th);
        },
        
        // Once called, loops indefinitely to track updates
        adjustEnablement: function () {
            const count = this.attachmentDownloadCheckboxes(true, true).length;
            const buttonText = count 
                ? TargetedSearch.getText("com.brikit.targetedsearch.content-query.table.download.attachments.with.count", [count])
                : TargetedSearch.getText("com.brikit.targetedsearch.content-query.table.download.attachments")
            this.downloadButton.find(".button-text").text(buttonText);
            this.downloadButton.prop("disabled", count ? false : "disabled");
            
            setTimeout(this.adjustEnablement.bind(this), 300);
        },
        
        adjustOrderForDocumentIdentifiers: function (results) {
            let needsReorder = false;
 			$.each(results, function(index, page) { if (TargetedSearch.contentFlowPageTitleWithDocumentId(page)) needsReorder = true; });
            if (!needsReorder) return results;
            return results.sort(function(a, b) {
                return TargetedSearch.contentFlowPageTitleWithDocumentId(a).localeCompare(TargetedSearch.contentFlowPageTitleWithDocumentId(b));
            });
        },
        
        allowAttachmentsDownload: function () {
            return this.loader.hasClass("allow-attachments-download");
        },
	
		append: function (html) {
			this.loader.append(html);
		},
	
        attachmentDownloadCheckboxes: function (checked, visibleOnly) {
            return this.find((visibleOnly ? "tr:not(.not-selectable) " : "") + "td.download-attachment-toggle input" + (checked ? ":checked" : ""));
        },
	
		autoload: function () {
			if (this.isLoading()) return;
		
			this.loader.addClass("loading");
			var data = {
				excerpt: (this.displaySimpleList() ? "none" : "highlight"),
				expand: this.expansions,
				start: this.nextResult(),
				limit: this.resultsSize()
			};
            
			var cqlContext = {};
			if (TargetedSearch.spaceKey) cqlContext["spaceKey"] = TargetedSearch.spaceKey;
			if (TargetedSearch.pageId) cqlContext["contentId"] = TargetedSearch.pageId;
			data["cqlcontext"] = JSON.stringify(cqlContext);
            
            var queryUrl = this.isAttachmentsTableMacro() 
                ? "/rest/api/content/" + this.containerPageId() + "/child/attachment"
                : "/rest/api/search?cql=" + TargetedSearch.cqlEncoded(this.cql());

			if (this.debug) console.log("Firing CQL search", data);
            if (this.debug) console.log(TargetedSearch.baseURL + queryUrl);
            // if (this.debug) TargetedSearch.cqlDebugViewer().show().html(TargetedSearch.cqlEncoded(this.cql()));
			$.ajax({
			    url: TargetedSearch.contextPath + queryUrl,
                data : data,
			    type: "GET",
                timeout: 30000,
			    success: this.loadResults.bind(this), 
				error: this.errorOccurredSearchAPI.bind(this),
                complete: function () { if (this.debug) console.log("Confluence Search API call completed", this.queryString())}.bind(this),
			    dataType: "json"
			});
		
		},
		
        checkAllDownloadCheckboxes: function (checked) {
            this.attachmentDownloadCheckboxes().prop("checked", checked ? "checked" : false);
            // this.adjustEnablement();
        },
        
		cleanUpAfterLoading: function () {
			this.removeLoadTrigger();
			this.loader.removeClass("loading");
		},
        
        containerPageId: function () {
            return this.data("container-page-id");
        },

		cql: function (cql) {
			if (typeof(cql) != "undefined") this.cqlValue = cql;
			return this.cqlValue;
		},
        
        data: function (suffix) {
            return this.loader.data(suffix);
        },
		
		displayIcons: function () {
			return this.loader.hasClass("display-icons");
		},
	
		displayLabels: function () {
			return this.loader.hasClass("display-labels");
		},
	
		displayRichLinks: function () {
			return this.loader.hasClass("display-rich-links") && !$("body").hasClass("admin-body"); // In admin screen, rich link styling is not available
		},
        
		displayTable: function () {
			return this.loader.hasClass("display-table") && !$("body").hasClass("admin-body"); // In admin screen, table display is not available
		},
	
		displayPage: function () {
			return this.loader.hasClass("display-page");
		},
	
		displaySpace: function () {
			return this.loader.hasClass("display-space");
		},
	
		displaySimpleList: function () {
			return this.loader.hasClass("display-simple-list");
		},
        
        downloadAttachments: function (e) {
            const ids = this.attachmentDownloadCheckboxes(true, true).map(function (i, b) { return "attachmentIds=" + $(b).data("attachment-id"); }).toArray().join("&");
            location.href = TargetedSearch.contextPath + "/plugins/targetedsearch/attachments/downloadattachments.action?" + ids;
        },
        
        embeddedResults: function () {
            const $results = this.find("script.embedded-query-results");
            let results = $results.length ? $.trim($results.html()) : "";
            if (results.indexOf("<![CDATA[") != -1) results = results.split("<![CDATA[")[1];
            if (results.indexOf("//]]>") != -1) results = results.split("//]]>")[0];
            if (results.indexOf("]]>") != -1) results = results.split("]]>")[0];
            return results ? JSON.parse(results) : false;
        },

		empty: function () {
			this.loader.empty();
		},
	
		emptySearch: function (callback) {
			this.empty();
			if (callback) callback({next: 0, totalMatches: 0, searchTime: 0, emptySearch: true});
		},

		errorOccurred: function (description, x, s, t) {
			this.cleanUpAfterLoading();
            
            if (x.responseJSON) {
                let json = x.responseJSON;
                let errorMessage = json.errorMessage || "";
                if (!errorMessage) errorMessage = json.responseText;
                if (!errorMessage && (json.statusCode == "401" || json.statusCode == "403")) errorMessage = "You are not logged in.";
                if (json.statusCode == "500") errorMessage = "Check space key and space categories in macro configuration.";
                if (!errorMessage) errorMessage = json.message;
                if (json.reason) errorMessage = json.reason + " - " + errorMessage;
                description += "Try searching again.<br\>(Error message: " + errorMessage + ")";
                this.loadResultsFinished(description);
            }
            else if (s == "timeout" || x.statusText == "timeout") {
                description += "Search timed out. Reload this page and try your search again.";
            }
            else {
                description += "Reload this page and try your search again."
            }
			this.removeLoadTrigger();
            this.loadResultsFinished(null, description);
		},
	
		errorOccurredCQL: function (x, s, t) {
            console.log("Error occurred when calling compose CQL: ", x, s, t)
			this.errorOccurred("Compose query failed. ", x, s, t);
		},
	
		errorOccurredSearchAPI: function (x, s, t) {
            console.log("Error occurred when calling the Confluence search API: ", x, s, t)
			this.errorOccurred("Confluence search failed. ", x, s, t);
		},
        
        filterGroupClasses: function () {
            const classes = this.data("filter-group-classes");
            return classes ? classes.split(",") : [];
        },
        
        filterGroupNameFromClass: function (classSafe) {
            return this.data("filter-group-name-" + classSafe);
        },
        
        find: function (selector) {
            return selector ? $(selector, this.loader) : this.loader;
        },
        
		formatResultForConfluenceDefaultSearch: function (result) {
			var $container = $("<a class='search-result'>").attr("href", TargetedSearch.contextPath + result.url);
			$container.append($("<span class='result-type-icon aui-icon'>").addClass(result.iconCssClass));

			var $title = $("<div>").addClass("title").html(this.highlightMarkedText(result.title));
			var $meta = $("<div>").addClass("search-result-meta");
			var $details = $("<div class='details'>").append($title);
			$container.append($details);
						
			if (result.entityType == "content") {
				$container.data("labels", this.labelsForResultIncludingInherited(result));
				
				var $highlight = $("<div>").addClass("highlights").html(this.highlightMarkedText(result.excerpt));
				$details.append($highlight);
                
                // No space is possible for Confluence Questions
				var $space = $("<span class='container'>").append(result.content.space ? result.content.space.name : "");
				$meta.append($space);
				
				var $lastModified = $("<span>").addClass("date").attr("title", TargetedSearch.getText("com.brikit.targetedsearch.last.modified")).text(result.friendlyLastModified);
				if (result.content.type == "attachment" || result.content.type == "comment") $meta.append($("<span>").text("/ … /")).append($("<span class='page'>").text(result.content.container.title));
				$meta.append($("<span class='spacer'>").append("•")).append($lastModified);
			}
			else if (result.entityType == "space") {
				$container.data("labels", result.space.metadata.labels);
				
				var $space = $("<p>").addClass("container").append("Space");
				$meta.append($space);
			}
			else if (result.entityType == "user") {
				var $userLink = $("<p>").addClass("container").append("User profile");
				$meta.append($userLink);
			}

			$details.append($meta);
			return $container;
			
		},
        
		formatResultForSimpleList: function (result) {
			var $li = $("<li>");

			if (this.displayIcons()) $li.append(this.resultIcon(result));

			var $details = $("<span>").addClass("details");
			
			$details.append(this.resultTitle(result));
			
			if (this.displaySpace()) $details.append($("<span>").addClass("smalltext").text(result.content.space ? result.content.space.name : ""));
			
			if (this.displayLabels()) $details.append($("<div>").addClass("label-details").append(this.resultLabels(result)));

			return $li.append($details);
		},
        
        formatResultForTable: function (result) {
            const $tr = $("<tr>");

            const isAttachment = result.content.type == "attachment"
            const $checkbox = this.getCheckbox("td", result.content.id); // .click(this.adjustEnablement.bind(this))
            if (this.allowAttachmentsDownload()) $tr.append(isAttachment ? $checkbox : $("<td>"));

            const $name = [];
			if (this.displayIcons()) $name.push(this.resultIcon(result));
            $name.push(this.resultTitle(result));
            this.addTd($tr, "title", $name, "title");

            const page = result.content.container
			if (this.displayPage()) this.addTd($tr, "attachment-page", $("<a>").attr("href", TargetedSearch.contextPath + page._links.webui).text(isAttachment ? page.title : ""), "page");
            
            const space = result.content.space
			if (this.displaySpace()) this.addTd($tr, "space-name", $("<a>").attr("href", TargetedSearch.contextPath + space._links.webui).text(space ? space.name : ""), "space");
            
			if (this.displayLabels()) this.addTd($tr, "label-list-cell", this.resultLabels(result), "labels");
            
            $.each(this.filterGroupClasses(), function (i, classSafe) {
                this.addTd($tr, "label-list-cell filter-group-" + classSafe, this.resultLabels(result, classSafe), "filter-group-" + classSafe);
            }.bind(this));
            
            this.adjustEnablement();
            
            return $tr;
        },
        
        getCheckbox: function (element, attachmentId) {
            return $("<" + element + ">").addClass("download-attachment-toggle").append($("<input>").attr("type", "checkbox").data("attachment-id", attachmentId));
        },
        
        getTableBody: function () {
            // If not added yet, add the table, header, and table body
            if (!this.find(".results-table tbody").length) {
                let $thead = $("<thead>");
                
                if (this.allowAttachmentsDownload()) $thead.append(this.getCheckbox("th").click(this.toggleDownloadCheckboxes.bind(this)));
                
                this.addTh($thead, "title", "com.brikit.targetedsearch.content-query.table.content.title", "title");

                if (this.displayPage()) this.addTh($thead,"page", "com.brikit.targetedsearch.content-query.table.attachment.page.title", "page");
                
                if (this.displaySpace()) this.addTh($thead, "space", "com.brikit.targetedsearch.content-query.table.space.title", "space");
                
                if (this.displayLabels()) this.addTh($thead, "labels", "com.brikit.targetedsearch.content-query.table.labels.title", "labels");
                
                $.each(this.filterGroupClasses(), function (i, classSafe) {
                    this.addTh($thead, "filter-group filter-group-" + classSafe, this.filterGroupNameFromClass(classSafe), "filter-group-" + classSafe);
                }.bind(this));
                
                let $tbody = $("<tbody>");
                let $table = $("<table>").addClass('confluenceTable results-table').append($thead).append($tbody);
                let $tableWrapper = $("<div>").addClass("results-table-wrapper").append($table);
                this.append($tableWrapper);
                
                const buttonText = TargetedSearch.getText("com.brikit.targetedsearch.content-query.table.download.attachments");
                this.downloadButton = $("<button>")
                    .addClass("aui-button download-attachments-button")
                    .append($("<span>").addClass("aui-icon aui-icon-small aui-iconfont-download"))
                    .append($("<span>").addClass("button-text").text(buttonText))
                    .prop("disabled", "disabled")
                    .click(this.downloadAttachments.bind(this));
                if (this.allowAttachmentsDownload()) $tableWrapper.append(this.downloadButton);
            }
            return this.find(".results-table tbody");
        },
        
        hideEmptyFilterGroupColumns: function () {
            if (!this.shouldHideEmptyFilterGroupColumns()) return;
            
            $.each(this.filterGroupClasses(), function (i, classSafe) {
                let $header = this.find("th.filter-group-" + classSafe);
                let $columns = this.find("td.filter-group-" + classSafe);
                let show = $(".aui-label", $columns).length;
                $header.showIf(show);
                $columns.showIf(show);
            }.bind(this));
        },
        
		highlightMarkedText: function (text) {
			return text.replace(/@@@hl@@@/g, "<strong>").replace(/@@@endhl@@@/g, "</strong>");
		},
        
        humanizeLabel: function (label) {
            return this.loader.data("label-filter-name-" + label) || TargetedSearch.Labels.humanizeLabel(label) || label;
        },
        
		ignoreThumbnails: function () {
			return this.loader.hasClass("ignore-thumbnails");
		},
        
		initialize: function () {		
            // Short circuit the query if the results are pre-embedded
            const results = this.embeddedResults();
            if (results) return this.loadResults(results);
            
			var cql = this.loader.data("cql");
			this.cql(cql);
			if (this.loader.data("next")) this.nextResult(this.loader.data("next"));

			if (this.loadsWithScroll()) {
				$(this.scrollingElement || window)
					.scroll(this.respondToBrowserChange.bind(this))
					.resize(this.respondToBrowserChange.bind(this));
			}
			else if (this.loadsWithButton()) {
				this.loadMoreButtonText = this.loader.data("load-more-button-text") || TargetedSearch.getText("com.brikit.targetedsearch.load.more");
				this.loader.on("click", ".load-more-button", function (e) { this.autoload(e); }.bind(this));
			}

			if (cql && !this.isLoading() && !this.loader.hasClass("do-not-search-on-page-load")) this.addLoadTrigger(true);
            
		},
        
        isAttachmentsTableMacro: function () {
            return this.loader.hasClass("attachments-table-macro");
        },
	
		isLoading: function () {
			return this.loader.hasClass("loading") || this.nextResult() < 0;
		},
	
        labelsForResultIncludingInherited: function (result) {
            // Regular labels
            let labels = result.content.metadata.labels;

            // Add inherited labels (look for nearest ancestor with cascading labels)
            let ancestorWithCascadingLabels = result.content.ancestors.reverse().filter(function(ancestor) { return ancestor.metadata.properties.cascadingLabels; });
            $.each(ancestorWithCascadingLabels, function (ai, ancestor) {
                if (ancestor.metadata.properties.cascadingLabels) $.each(ancestor.metadata.properties.cascadingLabels.value, function(index, label) {
                    if (!labels.results.filter(function (r) { return r.name == label }).length) labels.results = labels.results.concat([{prefix: "global", name: label}]);
                })
            });

            return labels;
        },
	
		loadTrigger: function () {
			return this.loader.find(".load-monitor, .load-more-button");
		},
	
		loadResults: function (data) {

			if (this.debug) console.log("loadResults with search results", data);
            
            // Note: data may be null if the Confluence search API fails.
			if (!data || data.responseText) {
				this.removeLoadTrigger();
				this.loadResultsFinished(data);
                return;
			}

            var sortedResults = this.adjustOrderForDocumentIdentifiers(data.results);
			if (this.displayRichLinks()) this.loadRichLinkResults(data, sortedResults);
            else if (this.displayTable()) this.loadTableResults(data, sortedResults);
			else if (this.displaySimpleList()) this.loadSimpleListResults(data, sortedResults);
			else this.loadTextResults(data, sortedResults);
		},
		
		loadResultsFinished: function (data, errorMessage) {
			this.cleanUpAfterLoading();

			if (!data || data.responseText || errorMessage) {
                // If data is null; the Confluence Search API completely failed
                // Since we have no way to resolve a Confluence error, just ignore the search attempt and display an error message.
				let error = "Confluence search failed. Try searching again.";
                if (errorMessage) error = errorMessage;
                else if (data) error = JSON.parse(data.responseText).message;
				if (this.debug) console.log("Error running search", error);
				this.addNoMoreResultsToLoader();
				this.callback({ next: 0, totalMatches: 0, searchTime: 0, error: error, nextResultAttempted: this.nextResult() });
				return;
			}
			
			this.nextResult(data.start + data.size);

			var proceed = !this.callback || this.callback({next: this.nextResult(), totalMatches: data.totalSize, searchTime: data.searchDuration / 1000.0});
			if (!proceed) return console.log("Callback function sent to TargetedSearch.MoreResultsLoader.restartSearch() canceled load more results by not returning true.", this.callback);
			
            let moreResults = this.nextResult() >= 0 && this.nextResult() < data.totalSize && (!this.loadsMoreDisabled() || this.displayTable());
			if (moreResults) this.addLoadTrigger(this.loadsAll(), this.callback);
			else this.addNoMoreResultsToLoader();
            
            if (!moreResults && this.displayTable()) this.hideEmptyFilterGroupColumns();
		},
        
		loadRichLinkResults: function (data, sortedResults) {

			var supportedTypes = ["page", "blogpost", "attachment", "space", "comment", "user"];
			var $form = $("<form>");
			$.each(sortedResults, function (i, result) {
				if (result.content && supportedTypes.indexOf(result.content.type) != -1) $form.append($("<input>").attr("name", "contentIds").val(result.content.id));
				else if (result.space && supportedTypes.indexOf("space") != -1) $form.append($("<input>").attr("name", "contentIds").val(result.space.key));
				else if (result.user && supportedTypes.indexOf("user") != -1) $form.append($("<input>").attr("name", "contentIds").val(result.user.userKey));
			});
            if (this.ignoreThumbnails()) $form.append($("<input>").attr("name", "ignoreThumbnails").val(true));
			if (this.debug) console.log("rich link ids being requested", $form.serialize());
			$.ajax({
			    url: TargetedSearch.contextPath + "/plugins/brikit/richlinks/multiple.action",
			    data : $form.serialize(),
			    type: "GET",
			    success: function (result) {
					this.removeLoadTrigger();
					this.append(result);
					this.loadResultsFinished(data);
				}.bind(this), 
				error: function(x,s,t) {console.log(x,s,t);}
			});
			
		},
		
        loadsAll: function () {
			return this.loader.hasClass("more-results-loader-auto");
        },
		
		loadSimpleListResults: function (data, sortedResults) {

			this.removeLoadTrigger();

			$.each(sortedResults, function (i, result) {
				this.append(this.formatResultForSimpleList(result));
			}.bind(this));
			
			this.loadResultsFinished(data);
			
		},
        
		loadsMoreDisabled: function () {
			return this.loader.hasClass("more-results-loader-off");
		},
	
		loadsWithButton: function () {
			return this.loader.hasClass("more-results-button-loader");
		},
	
		loadsWithScroll: function () {
			return this.loader.hasClass("more-results-scroll-loader");
		},
        
		loadTableResults: function (data, sortedResults) {

			this.removeLoadTrigger();
            
			$.each(sortedResults, function (i, result) {
				this.getTableBody().append(this.formatResultForTable(result));
			}.bind(this));
			
			this.loadResultsFinished(data);
			
		},
		
		loadTextResults: function (data, sortedResults) {

			this.removeLoadTrigger();

			$.each(sortedResults, function (i, result) {
				this.append(this.formatResultForConfluenceDefaultSearch(result));
			}.bind(this));
			
			this.loadResultsFinished(data);
			
		},
		
		nextResult: function (next) {
			if (typeof(next) != "undefined") this.nextValue = next;
			return this.nextValue;
		},
	
		queryString: function (queryString) {
			if (typeof(queryString) != "undefined") this.queryStringValue = queryString;
			return this.queryStringValue;
		},
	
		removeLoadTrigger: function () {
			this.loadTrigger().remove();
		},
	
		respondToBrowserChange: function () {
			clearTimeout(this.respondWaitTimeout);
            if (this.stopped) return;
			if (this.isLoading()) return this.respondWaitTimeout = setTimeout(this.respondToBrowserChange.bind(this), 300);
			if (this.loadTrigger().find(".aui-icon").aboveTheFold(0, true).length) this.autoload();
		},
		
		restartSearch: function (serializedSearchParameters, queryString, callback) {
			if (this.debug) console.log("Restarting search with parameters: " + serializedSearchParameters);
			this.queryString(queryString);
			$.ajax({
			    url: TargetedSearch.contextPath + "/plugins/targetedsearch/composecql.action",
			    data : serializedSearchParameters,
			    type: "POST",
                timeout: 30000,
			    success: function (response) { this.restartSearchWithCql(response.cql, callback); }.bind(this),
				error: this.errorOccurredCQL.bind(this),
                complete: function () { if (this.debug) console.log("Compose CQL call completed", this.queryString())}.bind(this),
			    dataType: "json"
			});
		},
		
		restartSearchWithCql: function (cql, callback, doNotClearPreviousResults) {
			if (this.isLoading()) return setTimeout(function () { this.restartSearchWithCql(cql, callback, doNotClearPreviousResults); }.bind(this), 200);
            
			this.cql(cql);
			this.nextResult(0);
			if (this.debug) console.log("Restarting search with CQL: " + TargetedSearch.cqlEncoded(this.cql()));

			if (!doNotClearPreviousResults) this.empty();
			this.addLoadTrigger(true, callback);
		},
		
        resultIcon: function(result) {
            return $("<span>").addClass("icon aui-icon").addClass(result.iconCssClass);
        },
        
        resultLabels: function (result, filterGroupSafeClass) {
            let resultsLabels = [];
            if (result.entityType == "content") resultsLabels = this.labelsForResultIncludingInherited(result).results;
            else if (result.entityType == "space") resultsLabels = result.space.metadata.labels;

            if (filterGroupSafeClass) {
                resultsLabels = $(resultsLabels).filter(function (i, l) {
                    return this.data("label-filter-group-name-safe-x" + l.name) == filterGroupSafeClass;
                }.bind(this));
            }

			var $labelList = $("<ul>").addClass("label-list");
			$.each(resultsLabels, function (i, label) {
                let labelDisplayName = this.humanizeLabel(label.name)
				var $label = $("<a>").addClass("aui-label-split-main").attr("onclick", "return false;").attr("rel", "tag").text(labelDisplayName);
				$labelList.append($("<li>").addClass("aui-label").attr("data-label-id", label.id).attr("data-label", label.name).append($label));
			}.bind(this));
			return $labelList;
        },
        
		resultsSize: function () {
			return this.loader.data("chunk-size");
		},
        
        resultTitle: function (result) {
            return $("<a>").addClass("title").attr("href", TargetedSearch.contextPath + result.url).html(result.title);
        },
        
        shouldHideEmptyFilterGroupColumns: function () {
            return this.loader.hasClass("hide-empty-filter-group-columns");
        },
	
        sortColumn: function ($th) {
            const sortKey = $th.data("sortKey");
            const ascending = $th.hasClass("sort-up");
            const $tbody = this.find("tbody");
            const cellText = function (tr) {
                return $("td[data-sort-key=" + sortKey + "]", tr).text();
            }
            $tbody.find("tr").sort(function(aTr, bTr) {
                const a = cellText(aTr);
                const b = cellText(bTr);
                
                // Handle empty cells. Empty cells should appear below populated ones.
                if (!a && b) return 1;
                if (a && !b) return -1;
                
                return ascending ? a.localeCompare(b) : b.localeCompare(a);
            }).appendTo($tbody);
        },
        
        startSearch: function () {
            this.stopped = false;
        },
        
        stopSearch: function () {
            this.stopped = true;
        },
        
        toggleDownloadCheckboxes: function (e) {
            this.checkAllDownloadCheckboxes(this.find("th.download-attachment-toggle input:checked").length);
        }
        
	});
	
	TargetedSearch.toInit(function ($) {
		$(".more-results-scroll-loader, .more-results-button-loader, .more-results-loader-off").each(function () { new TargetedSearch.MoreResultsLoader(this); });
	});

})(jQuery);
