/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class SearchSettingsImporter {
    protected static final int COLUMN_COUNT = 8;
    protected static final int OLD_COLUMN_COUNT = 4;
    protected BrikitList<String> errors;
    protected BrikitMap<String, FilterGroup> filterGroupsByName;
    protected BrikitMap<String, Filter> filtersByDisplayName;
    protected BrikitMap<String, Filter> filtersByLabel;

    protected void addError(String error) {
        this.getErrors().add(error);
    }

    protected void addErrors(List<String> errors) {
        for (String error : errors) {
            this.addError(error);
        }
    }

    public BrikitList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new BrikitList();
        }
        return this.errors;
    }

    public BrikitMap<String, FilterGroup> getFilterGroupsByName() {
        if (this.filterGroupsByName == null) {
            this.filterGroupsByName = new BrikitMap();
        }
        return this.filterGroupsByName;
    }

    public BrikitMap<String, Filter> getFiltersByDisplayName() {
        if (this.filtersByDisplayName == null) {
            this.filtersByDisplayName = new BrikitMap();
        }
        return this.filtersByDisplayName;
    }

    public BrikitMap<String, Filter> getFiltersByLabel() {
        if (this.filtersByLabel == null) {
            this.filtersByLabel = new BrikitMap();
        }
        return this.filtersByLabel;
    }

    protected boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSettings(UploadedFile dataFile) {
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            FilterGroup.resetCaches(false);
            try {
                File file = dataFile.isFile() ? (File)dataFile.getContent() : null;
                BrikitList<String> linesWithoutHeader = new BrikitList<String>((List<String>)BrikitFile.readFileUTF8Lines(file));
                String header = (String)linesWithoutHeader.remove(0);
                String[] headerElements = header.split("\\t");
                boolean oldFormat = headerElements.length < 8;
                for (String rawSetting : linesWithoutHeader) {
                    this.rehydrateSetting(rawSetting, oldFormat);
                }
            }
            catch (Exception ex) {
                this.addError("Unable to read file.");
            }
            if (this.hasErrors()) {
                FilterGroup.resetCaches(true);
                Folksonomy.resetCache();
            } else {
                FilterGroup.saveFilterGroups();
                Folksonomy.saveFolksonomy();
            }
            FilterGroup.resetCaches();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void rehydrateFilter(List<String> elements, boolean oldFormat) {
        if (elements.size() < (oldFormat ? 4 : 8)) {
            this.addError("Row contains insufficient data to create Filter: " + elements.get(0));
            return;
        }
        String filterGroupName = BrikitString.trimToString(elements.get(0));
        boolean promoted = !oldFormat && BrikitBoolean.booleanValue(elements.get(5));
        String filterName = elements.get(oldFormat ? 2 : 6);
        String filterLabel = elements.get(oldFormat ? 3 : 7);
        BrikitLog.logDebug("Importing Filter: " + filterName + " for FilterGroup : " + filterGroupName + ". Finding FilterGroup...");
        FilterGroup parentFilterGroup = (FilterGroup)this.getFilterGroupsByName().get(filterGroupName);
        if (parentFilterGroup == null) {
            this.addError("No FilterGroup found by name " + parentFilterGroup + " for Filter " + filterName + ". Filter not saved.");
            return;
        }
        Filter filter = new Filter(parentFilterGroup, filterName, filterLabel, promoted);
        BrikitList<String> validationErrors = filter.validate(this.getFiltersByDisplayName(), this.getFiltersByLabel());
        if (validationErrors.isEmpty()) {
            parentFilterGroup.addFilter(filter);
            this.getFiltersByDisplayName().put(filter.getDisplayName(), filter);
            this.getFiltersByLabel().put(filter.getLabel(), filter);
            Folksonomy.delete(filter.getLabel(), false);
        } else {
            this.addErrors(validationErrors);
        }
    }

    protected void rehydrateFilterGroup(List<String> elements, boolean oldFormat) {
        String displayName = BrikitString.trimToString(elements.get(0));
        BrikitList<String> visibleTo = elements.size() > 1 ? BrikitString.splitCommaOrSpaceSeparated(elements.get(1)) : Collections.EMPTY_LIST;
        BrikitList<String> excludeFrom = elements.size() > 2 ? BrikitString.splitCommaOrSpaceSeparated(elements.get(2)) : Collections.EMPTY_LIST;
        String prefix = elements.size() > 3 ? BrikitString.trimToNull(elements.get(3)) : null;
        boolean promoted = elements.size() > 5 ? BrikitBoolean.booleanValue(elements.get(5)) : false;
        BrikitLog.logDebug("Saving FilterGroup: " + displayName);
        FilterGroup filterGroup = new FilterGroup(displayName, visibleTo, excludeFrom, prefix, promoted);
        List<String> validationErrors = filterGroup.validate();
        String parentFilterLabel = elements.size() > 4 ? BrikitString.trimToNull(elements.get(4)) : null;
        Filter parentFilter = null;
        if (parentFilterLabel != null && (parentFilter = (Filter)this.getFiltersByLabel().get(parentFilterLabel)) == null) {
            validationErrors.add("No parent filter (" + parentFilterLabel + ") found to hold subcategory: " + displayName);
        }
        if (!validationErrors.isEmpty()) {
            this.addErrors(validationErrors);
            return;
        }
        this.getFilterGroupsByName().put(displayName, filterGroup);
        if (parentFilter == null) {
            FilterGroup.addImportedFilterGroup(filterGroup);
        } else {
            parentFilter.addSubcategory(filterGroup);
        }
    }

    protected void rehydrateSetting(String rawSetting, boolean oldFormat) {
        String[] rawElements = rawSetting.split("\\t");
        List<String> elements = Arrays.asList(rawElements);
        if (elements.size() < 1 || !BrikitString.isSet(elements.get(0))) {
            return;
        }
        if (elements.size() < (oldFormat ? 4 : 8)) {
            this.rehydrateFilterGroup(elements, oldFormat);
        } else {
            this.rehydrateFilter(elements, oldFormat);
        }
    }
}

