/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.api.model.search.SearchContext;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;

public class AbstractTargetedSearchAdminAction
extends AbstractTargetedSearchAction {
    public int getPagesUsingLabelCount(String aLabel) {
        if (!BrikitString.isSet(aLabel) || !Confluence.isValidLabelName(aLabel)) {
            return 0;
        }
        String cql = "type in (page,blogpost,attachment) and label in ('" + aLabel + "')";
        SearchContext searchContext = SearchContext.builder().build();
        return Confluence.getSearchService().countContent(cql, searchContext);
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(Confluence.getText("config.insufficient.permissions"));
        }
    }
}

