(function ($) { 

	TargetedSearch.Folksonomy = {

		closeForms: function (event) {
			event.stopPropagation();
			TargetedSearch.Folksonomy.replaceLabelForm(this).slideUp("fast");
			TargetedSearch.Folksonomy.promoteLabelForm(this).slideUp("fast");
		},
		
		clearReplaceLabels: function (event) {
			event.preventDefault();
			console.log($("#general-replace-label-form fieldset input").length)
			$("#general-replace-label-form fieldset input").val("");
		},
		
		folksonomy: function (selector) {
			var $folksonomy = $("#folksonomy");
			return selector ? $(selector, $folksonomy) : $folksonomy;
		},
		
		ignoreLabel: function (event) {
			event.preventDefault();

			var label = $(this).closest("tr").data("label");
			var url = $(this).attr("href");

			TargetedSearch.Dialog2.confirm(
				TargetedSearch.getText("com.brikit.targetedsearch.confirm.stop.tracking.label", [label]), 
				{ title: TargetedSearch.getText("com.brikit.targetedsearch.confirm") },
				function (dialog) {
					$.post(url, { label: label }, function (response, textStatus, jqXHR) {
						response = $.parseJSON(response);
						if (response.error) TargetedSearch.Dialog2.alert(response.error, { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
						TargetedSearch.reloadBrowser();
					});
				}
			);
		},
		
		promoteLabel: function (event) {
			event.preventDefault();

			var $form = $(this);
			var label = $form.closest("tr").data("label");
			var filterGroupName = $form.find("select[name=filterGroupKey] option:selected").text();
			var filterGroupKey = $form.find("select[name=filterGroupKey]").val();
			var filterName = $.trim($form.find("input[name=filterName]").val());
			if (!filterName) return TargetedSearch.Dialog2.alert(TargetedSearch.getText("com.brikit.targetedsearch.filter.name.cannot.be.blank"), { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
			
			TargetedSearch.Dialog2.confirm(
				TargetedSearch.getText("com.brikit.targetedsearch.confirm.promote.label", [label, filterGroupName, filterName]), 
				{ title: TargetedSearch.getText("com.brikit.targetedsearch.confirm") },
				function (dialog) {
					$.post($form.attr("action"), { label: label, filterGroupKey: filterGroupKey, filterName: filterName }, function (response, textStatus, jqXHR) {
						response = $.parseJSON(response);
						dialog.hide();
						if (response.error) TargetedSearch.Dialog2.alert(response.error, { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
						else TargetedSearch.reloadBrowser();
					});
				}
			);
			
			return false;
		},
		
		promoteLabelForm: function (element) {
			return $(element).closest("tr").find(".promote-label-form");
		},
		
		replaceLabel: function (event) {
			event.preventDefault();

			var $form = $(this);
			var oldLabels = $.trim($form.find("input[name=oldLabels]").val());
			var newLabels = $.trim($form.find("input[name=newLabels]").val());
			var spaceKey = $.trim($form.find("input[name=spaceKey]").val());
			if (!oldLabels) return TargetedSearch.Dialog2.alert(TargetedSearch.getText("com.brikit.targetedsearch.label.cannot.be.blank"), { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
			if (!newLabels) return TargetedSearch.Dialog2.alert(TargetedSearch.getText("com.brikit.targetedsearch.label.cannot.be.blank"), { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
			
			var message = spaceKey ? "com.brikit.targetedsearch.confirm.replace.label.space" : "com.brikit.targetedsearch.confirm.replace.label.global";
			TargetedSearch.Dialog2.confirm(
				TargetedSearch.getText(message, [oldLabels, newLabels, spaceKey]), 
				{ title: TargetedSearch.getText("com.brikit.targetedsearch.confirm") },
				function (dialog) {
        			$.ajax({
        			    url: $form.attr("action"),
        			    data : { oldLabels: oldLabels, newLabels: newLabels, spaceKey: spaceKey },
        			    type: "POST",
                        timeout: 600000,
        			    success: function (response, textStatus, jqXHR) {
    						dialog.hide();
    						response = $.parseJSON(response);
    						if (response.error) TargetedSearch.Dialog2.alert(response.error, { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
    						else TargetedSearch.reloadBrowser();
    					}, 
        				error: function (x, s, t) {
                            let msg = s == "timeout" ? "The label replacement call timed out." : "An error occurred while replacing labels. \n\nCheck javascript console for details.";
                            console.log(msg, x, s, t);
                            alert(msg);
                		}
        			});
				}
			);
			
			return false;
		},
		
		replaceLabelForm: function (element) {
			return $(element).closest("tr").find(".replace-label-form");
		},
		
		showCountResults: function (event) {
			event.preventDefault();
			var label = $(this).data("label");
            TargetedSearch.SearchPanel.openSearch("folksonomyLabels=" + label);
		},
		
		showPromoteLabelForm: function (event) {
			event.preventDefault();

			TargetedSearch.Folksonomy.replaceLabelForm(this).hide("fast");
			TargetedSearch.Folksonomy.promoteLabelForm(this).slideDown("fast");
		},
		
		showReplaceLabelForm: function (event) {
			event.preventDefault();

			TargetedSearch.Folksonomy.promoteLabelForm(this).hide("fast");
			TargetedSearch.Folksonomy.replaceLabelForm(this).slideDown("fast");
		}
	
	 };
  
	 TargetedSearch.toInit( function ($) {
		 TargetedSearch.Folksonomy.folksonomy().on("click contextmenu", ".pages-using-label-link", TargetedSearch.Folksonomy.showCountResults);
		 
		 TargetedSearch.Folksonomy.folksonomy().on("click", ".ignore-label", TargetedSearch.Folksonomy.ignoreLabel);
		 TargetedSearch.Folksonomy.folksonomy().on("click", ".promote-label", TargetedSearch.Folksonomy.showPromoteLabelForm);
		 TargetedSearch.Folksonomy.folksonomy().on("click", ".replace-label", TargetedSearch.Folksonomy.showReplaceLabelForm);
		 TargetedSearch.Folksonomy.folksonomy().on("click", ".cancel", TargetedSearch.Folksonomy.closeForms);
		 TargetedSearch.Folksonomy.folksonomy().on("submit", ".promote-label-form", TargetedSearch.Folksonomy.promoteLabel);
		 TargetedSearch.Folksonomy.folksonomy().on("submit", ".replace-label-form", TargetedSearch.Folksonomy.replaceLabel);

		 $("#general-replace-label-form").submit(TargetedSearch.Folksonomy.replaceLabel);
		 $("#general-replace-label-holder").on("click", ".clear-all", TargetedSearch.Folksonomy.clearReplaceLabels);
	 });

})(jQuery);