/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAdminAction;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.util.Collections;
import java.util.List;

public class ManageFolksonomyAction
extends AbstractTargetedSearchAdminAction {
    protected String label;

    public List<String> getFolksonomy() {
        if (!this.isLicensed()) {
            return Collections.EMPTY_LIST;
        }
        BrikitList<String> folksonomy = Folksonomy.getFolksonomyCopy();
        Collections.sort(folksonomy);
        return folksonomy;
    }

    public List<FilterGroup> getFilterGroups() {
        return FilterGroup.getFilterGroups();
    }

    public String getLabel() {
        return this.label;
    }

    public String ignoreLabel() {
        JSONObject json = new JSONObject();
        if (!Folksonomy.isOnList(this.getLabel())) {
            json.put("error", (Object)this.getText("com.brikit.targetedsearch.label.not.in.folksonomy", Collections.singletonList(this.getLabel())));
        } else {
            Folksonomy.delete(this.getLabel());
            json.put("success", true);
        }
        this.setResult(json.toString());
        return "success";
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void validate() {
        if (!TargetedSearch.canEditTaxonomy()) {
            this.addActionError(Confluence.getText("config.insufficient.permissions"));
        }
    }
}

