/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.listeners;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.brikit.targetedsearch.model.FilterGroup;
import org.springframework.beans.factory.DisposableBean;

public class SpaceEventListener
implements DisposableBean {
    protected EventPublisher eventPublisher;

    public SpaceEventListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void labelEvent(LabelEvent event) {
        Labelable labelable = event.getLabelled();
        if (labelable instanceof SpaceContentEntityObject) {
            FilterGroup.resetCaches();
        }
    }

    @EventListener
    public void spaceCreateEvent(SpaceCreateEvent event) {
        FilterGroup.resetCaches();
    }

    @EventListener
    public void spaceRemoveEvent(SpaceRemoveEvent event) {
        FilterGroup.resetCaches();
    }

    @EventListener
    public void spaceUpdateEvent(SpaceUpdateEvent event) {
        FilterGroup.resetCaches();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

